/*
 * Decompiled with CFR 0.152.
 */
package me.thegiggitybyte.sleepwarp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import me.thegiggitybyte.sleepwarp.config.SleepWarpConfig;
import me.thegiggitybyte.sleepwarp.runnable.BlockTickRunnable;
import me.thegiggitybyte.sleepwarp.runnable.LightningTickRunnable;
import me.thegiggitybyte.sleepwarp.runnable.MobTickRunnable;
import me.thegiggitybyte.sleepwarp.runnable.PrecipitationTickRunnable;
import me.thegiggitybyte.sleepwarp.runnable.RandomTickRunnable;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2761;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3898;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class WarpEngine {
    public static final int DAY_LENGTH_TICKS = 24000;
    private static WarpEngine instance;
    private final Random random = new Random();

    private WarpEngine() {
        EntitySleepEvents.ALLOW_SLEEP_TIME.register(this::allowSleepTime);
        ServerTickEvents.END_WORLD_TICK.register(this::onEndTick);
    }

    public static void initialize() {
        if (instance != null) {
            throw new AssertionError();
        }
        instance = new WarpEngine();
    }

    private class_1269 allowSleepTime(class_1657 player, class_2338 sleepingPos, boolean vanillaResult) {
        if (!vanillaResult && player.method_73183().method_8532() % 24000L > 12542L) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void onEndTick(class_3218 world) {
        int warpTickCount;
        int percentRequired;
        int minimumSleeping;
        if (!world.method_33144()) {
            return;
        }
        int totalPlayers = world.method_18456().size();
        long sleepingPlayers = world.method_18456().stream().filter(class_1657::method_7276).count();
        if (sleepingPlayers == 0L) {
            return;
        }
        if (SleepWarpConfig.use_sleep_percentage && sleepingPlayers < (long)(minimumSleeping = Math.max(1, class_3532.method_15386((float)((float)(totalPlayers * (percentRequired = world.method_64395().method_8356(class_1928.field_28357))) / 100.0f))))) {
            return;
        }
        int maxTicksAdded = Math.max(10, SleepWarpConfig.max_ticks_added);
        double playerMultiplier = Math.max(0.05, Math.min(1.0, SleepWarpConfig.player_multiplier));
        long worldTime = world.method_8532() % 24000L;
        if (worldTime + (long)maxTicksAdded < 24000L) {
            if (totalPlayers == 1) {
                warpTickCount = maxTicksAdded;
            } else {
                double sleepingRatio = (double)sleepingPlayers / (double)totalPlayers;
                double scaledRatio = sleepingRatio * playerMultiplier;
                double tickMultiplier = scaledRatio / (scaledRatio * 2.0 - playerMultiplier - sleepingRatio + 1.0);
                warpTickCount = Math.toIntExact(Math.round((double)maxTicksAdded * tickMultiplier));
            }
        } else {
            warpTickCount = Math.toIntExact(24000L % worldTime);
        }
        class_3898 chunkStorage = world.method_14178().field_17254;
        ArrayList chunks = new ArrayList();
        chunkStorage.method_74529(chunk -> {
            if (chunk != null && world.method_67504(chunk.method_12004()) && chunkStorage.method_38783(chunk.method_12004())) {
                chunks.add(chunk);
            }
        });
        boolean doDaylightCycle = world.field_24456.method_146().method_8355(class_1928.field_19396);
        for (int tick = 0; tick < warpTickCount; ++tick) {
            world.method_39501();
            world.method_8533();
            if (SleepWarpConfig.tick_game_time) {
                world.method_29203();
            } else {
                world.method_29199(world.method_8532() + 1L);
            }
            class_2761 packet = new class_2761(world.method_8510(), world.method_8532(), doDaylightCycle);
            world.method_8503().method_3760().method_14589((class_2596)packet, world.method_27983());
            Collections.shuffle(chunks);
            for (class_2818 chunk2 : chunks) {
                if (SleepWarpConfig.tick_random_block) {
                    this.execute(world, new RandomTickRunnable(world, chunk2));
                }
                if (!world.method_8419()) continue;
                if (SleepWarpConfig.tick_lightning && world.method_8546() && this.random.nextInt(100000) == 0) {
                    this.execute(world, new LightningTickRunnable(world, chunk2));
                }
                if (this.random.nextInt(16) != 0) continue;
                this.execute(world, new PrecipitationTickRunnable(world, chunk2));
            }
            if (!SleepWarpConfig.tick_block_entities) continue;
            this.execute(world, new BlockTickRunnable(world));
        }
        if (SleepWarpConfig.tick_animals | SleepWarpConfig.tick_monsters) {
            this.execute(world, new MobTickRunnable(world, warpTickCount));
        }
        worldTime = world.method_8532() % 24000L;
        class_5250 actionBarText = null;
        if (worldTime == 0L) {
            if (world.method_8419()) {
                world.method_14195();
            }
            world.method_23660();
            String currentDay = String.valueOf(world.method_8532() / 24000L);
            actionBarText = class_2561.method_43469((String)"text.sleepwarp.day", (Object[])new Object[]{class_2561.method_43470((String)currentDay).method_27692(class_124.field_1065)});
        } else if (worldTime > 0L) {
            long remainingTicks;
            long l = remainingTicks = world.method_8546() ? (long)world.field_24456.method_145() : 24000L - worldTime;
            if (remainingTicks > 0L) {
                actionBarText = class_2561.method_43473();
                if (totalPlayers > 1) {
                    double actualPercentage = (double)sleepingPlayers / (double)totalPlayers;
                    double requiredPercentage = 1.0 - playerMultiplier;
                    class_124 indicatorColor = actualPercentage >= requiredPercentage ? class_124.field_1077 : class_124.field_1061;
                    String playerNoun = sleepingPlayers == 1L ? "player" : "players";
                    actionBarText.method_10852((class_2561)class_2561.method_43469((String)("text.sleepwarp." + playerNoun + "_sleeping"), (Object[])new Object[]{class_2561.method_43470((String)("\u231b " + sleepingPlayers + " ")).method_27692(indicatorColor)}));
                } else {
                    actionBarText.method_10852((class_2561)class_2561.method_43470((String)"\u231b").method_27692(class_124.field_1065));
                }
                long remainingSeconds = Math.round((double)remainingTicks / (double)warpTickCount / 20.0);
                actionBarText.method_10852((class_2561)class_5244.method_48320());
                actionBarText.method_10852((class_2561)class_2561.method_43469((String)("text.sleepwarp.until_" + (world.method_8546() ? "thunderstorm" : "dawn")), (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(remainingSeconds))}));
            }
        }
        if (SleepWarpConfig.action_bar_messages) {
            for (class_3222 player : world.method_18456()) {
                player.method_7353((class_2561)actionBarText, true);
            }
        }
    }

    private void execute(class_3218 world, Runnable runnable) {
        world.method_8503().execute(runnable);
    }
}

