/*
 * Decompiled with CFR 0.152.
 */
package me.thegiggitybyte.sleepwarp.mixin.common;

import me.thegiggitybyte.sleepwarp.config.SleepWarpConfig;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5838;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_3218.class})
public abstract class ServerWorldMixin
extends class_1937 {
    protected ServerWorldMixin(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry, boolean isClient, boolean debugWorld, long seed, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, isClient, debugWorld, seed, maxChainedNeighborUpdates);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/SleepManager;canSkipNight(I)Z"))
    private boolean suppressVanillaSleep(class_5838 instance, int percentage) {
        return false;
    }

    @Redirect(method={"updateSleepingPlayers"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;sendSleepingStatus()V"))
    private void sendWarpStatus(class_3218 world) {
        if (world.method_8503().method_3724() || !world.method_8503().method_3860() || world.method_18456().size() == 1) {
            return;
        }
        if (!SleepWarpConfig.action_bar_messages) {
            return;
        }
        long playerCount = 0L;
        long inBedCount = 0L;
        long sleepingCount = 0L;
        for (class_3222 player : world.method_18456()) {
            if (player.method_6113()) {
                if (player.method_7297() >= 100) {
                    ++sleepingCount;
                }
                ++inBedCount;
            }
            ++playerCount;
        }
        class_5250 messageText = null;
        class_5250 tallyText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)String.valueOf(inBedCount))).method_27693("/").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(playerCount)));
        if (inBedCount == 0L) {
            messageText = class_2561.method_43469((String)"text.sleepwarp.players_sleeping", (Object[])new Object[]{tallyText.method_27692(class_124.field_1063)});
        } else if (SleepWarpConfig.use_sleep_percentage) {
            int percentRequired = world.method_64395().method_8356(class_1928.field_28357);
            long minSleepingCount = Math.max(1L, playerCount * (long)percentRequired / 100L);
            messageText = sleepingCount < minSleepingCount && minSleepingCount - inBedCount > 0L ? class_2561.method_43469((String)"text.sleepwarp.players_sleeping.more_required", (Object[])new Object[]{tallyText.method_27692(class_124.field_1061), String.valueOf(minSleepingCount - inBedCount)}) : class_2561.method_43469((String)"text.sleepwarp.players_sleeping", (Object[])new Object[]{tallyText.method_27692(class_124.field_1077)});
        } else if (sleepingCount == 0L) {
            messageText = class_2561.method_43469((String)"text.sleepwarp.players_sleeping", (Object[])new Object[]{tallyText.method_27692(class_124.field_1054)});
        }
        if (messageText != null) {
            for (class_3222 player : world.method_18456()) {
                player.method_7353((class_2561)messageText, true);
            }
        }
    }
}

