/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.gui;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.config.PunchyConfig;
import java.util.Locale;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;

public class PunchyConfigScreen
extends class_437 {
    private final class_437 parent;
    private class_4185 originalButton;
    private class_4185 realisticButton;
    private class_4185 punchyaButton;
    private class_4185 doneButton;
    private class_5676<PunchyConfig.SwordSpeed> swordSpeedToggle;
    private class_5676<PunchyConfig.BlockPlaceSpeed> blockPlaceSpeedToggle;
    private class_5676<Boolean> removeCooldownToggle;
    private class_5676<Boolean> hideIndicatorToggle;
    private class_5676<Boolean> impactTimingToggle;
    private class_5676<Boolean> debugPositionToggle;
    private PunchyConfig config;
    private final boolean devMode;

    public PunchyConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Punchy Config"));
        this.parent = parent;
        this.config = PunchyConfig.load();
        this.devMode = FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    protected void method_25426() {
        int doneButtonY;
        int centerX = this.field_22789 / 2;
        int startY = this.field_22790 / 3;
        this.applySpeedPreset();
        boolean originalSelected = this.config.getSpeedPreset() == PunchyConfig.SpeedPreset.ORIGINAL;
        boolean realisticSelected = this.config.getSpeedPreset() == PunchyConfig.SpeedPreset.REALISTIC;
        boolean punchyaSelected = this.config.getSpeedPreset() == PunchyConfig.SpeedPreset.PUNCHYA;
        int buttonWidth = 150;
        int buttonSpacing = 4;
        int totalWidth = buttonWidth * 3 + buttonSpacing * 2;
        int leftStart = centerX - totalWidth / 2;
        this.originalButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"DEBUG"), b -> {
            this.config.setSpeedPreset(PunchyConfig.SpeedPreset.ORIGINAL);
            this.config.save();
            this.applySpeedPreset();
            this.updateSelected();
        }).method_46433(leftStart, startY + 20).method_46437(buttonWidth, 20).method_46431());
        this.realisticButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Realistic"), b -> {
            this.config.setSpeedPreset(PunchyConfig.SpeedPreset.REALISTIC);
            this.config.save();
            this.applySpeedPreset();
            this.updateSelected();
        }).method_46433(leftStart + buttonWidth + buttonSpacing, startY + 20).method_46437(buttonWidth, 20).method_46431());
        this.punchyaButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Punchya!"), b -> {
            this.config.setSpeedPreset(PunchyConfig.SpeedPreset.PUNCHYA);
            this.config.save();
            this.applySpeedPreset();
            this.updateSelected();
        }).method_46433(leftStart + (buttonWidth + buttonSpacing) * 2, startY + 20).method_46437(buttonWidth, 20).method_46431());
        int swordToggleY = startY + 52;
        this.swordSpeedToggle = (class_5676)this.method_37063((class_364)class_5676.method_32606(value -> class_2561.method_43470((String)value.label)).method_32624((Object[])PunchyConfig.SwordSpeed.values()).method_32619((Object)this.config.getSwordSpeed()).method_32617(centerX - 154, swordToggleY, 308, 20, (class_2561)class_2561.method_43470((String)"Velocidade da espada"), (button, value) -> {
            this.config.setSwordSpeed((PunchyConfig.SwordSpeed)((Object)value));
            Punchy.SWORD_ANIM_SPEED = value.multiplier;
            Punchy.applyCombatToggles(this.config);
            this.config.save();
            this.sendSpeedStatus();
        }));
        int blockSpeedToggleY = swordToggleY + 26;
        this.blockPlaceSpeedToggle = (class_5676)this.method_37063((class_364)class_5676.method_32606(value -> class_2561.method_43470((String)value.label)).method_32624((Object[])PunchyConfig.BlockPlaceSpeed.values()).method_32619((Object)this.config.getBlockPlaceSpeed()).method_32617(centerX - 154, blockSpeedToggleY, 308, 20, (class_2561)class_2561.method_43470((String)"Velocidade de colocar blocos"), (button, value) -> {
            this.config.setBlockPlaceSpeed((PunchyConfig.BlockPlaceSpeed)((Object)value));
            Punchy.BLOCK_PLACE_SPEED = value.multiplier;
            Punchy.applyCombatToggles(this.config);
            this.config.save();
            this.sendSpeedStatus();
        }));
        int toggleStartY = blockSpeedToggleY + 32;
        if (this.devMode) {
            this.removeCooldownToggle = (class_5676)this.method_37063((class_364)class_5676.method_32614().method_32619((Object)this.config.isRemoveAttackCooldown()).method_32617(centerX - 154, toggleStartY, 308, 20, (class_2561)class_2561.method_43470((String)"Cooldown removido"), (button, value) -> {
                this.config.setRemoveAttackCooldown((boolean)value);
                Punchy.applyCombatToggles(this.config);
                this.config.save();
            }));
            this.hideIndicatorToggle = (class_5676)this.method_37063((class_364)class_5676.method_32614().method_32619((Object)this.config.isHideAttackIndicator()).method_32617(centerX - 154, toggleStartY + 24, 308, 20, (class_2561)class_2561.method_43470((String)"HUD sem barra"), (button, value) -> {
                this.config.setHideAttackIndicator((boolean)value);
                Punchy.applyCombatToggles(this.config);
                this.config.save();
            }));
            this.impactTimingToggle = (class_5676)this.method_37063((class_364)class_5676.method_32614().method_32619((Object)this.config.isUseImpactTiming()).method_32617(centerX - 154, toggleStartY + 48, 308, 20, (class_2561)class_2561.method_43470((String)"Dano no impact"), (button, value) -> {
                this.config.setUseImpactTiming((boolean)value);
                Punchy.applyCombatToggles(this.config);
                this.config.save();
            }));
            this.debugPositionToggle = (class_5676)this.method_37063((class_364)class_5676.method_32614().method_32619((Object)this.config.isDebugPosition()).method_32617(centerX - 154, toggleStartY + 72, 308, 20, (class_2561)class_2561.method_43470((String)"Debug position keybinds"), (button, value) -> {
                this.config.setDebugPosition((boolean)value);
                Punchy.applyCombatToggles(this.config);
                this.config.save();
                this.sendSpeedStatus();
            }));
            doneButtonY = toggleStartY + 140;
        } else {
            this.removeCooldownToggle = null;
            this.hideIndicatorToggle = null;
            this.impactTimingToggle = null;
            this.debugPositionToggle = null;
            doneButtonY = blockSpeedToggleY + 60;
        }
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, b -> this.method_25419()).method_46433(centerX - 75, doneButtonY).method_46437(150, 20).method_46431());
        this.originalButton.field_22763 = !originalSelected;
        this.realisticButton.field_22763 = !realisticSelected;
        this.punchyaButton.field_22763 = !punchyaSelected;
        this.sendSpeedStatus();
    }

    private void updateSelected() {
        boolean originalSelected = this.config.getSpeedPreset() == PunchyConfig.SpeedPreset.ORIGINAL;
        boolean realisticSelected = this.config.getSpeedPreset() == PunchyConfig.SpeedPreset.REALISTIC;
        boolean punchyaSelected = this.config.getSpeedPreset() == PunchyConfig.SpeedPreset.PUNCHYA;
        this.originalButton.field_22763 = !originalSelected;
        this.realisticButton.field_22763 = !realisticSelected;
        this.punchyaButton.field_22763 = !punchyaSelected;
        this.sendSpeedStatus();
    }

    private void sendSpeedStatus() {
        class_310 client = this.field_22787;
        if (client != null && client.field_1724 != null) {
            String message = this.devMode ? String.format(Locale.ROOT, "Velocidade geral: %s (x%.1f) | Espada: %s | Blocos: %s | DebugPos: %s", this.config.getSpeedPreset().label, Punchy.ANIM_SPEED, this.config.getSwordSpeed().label, this.config.getBlockPlaceSpeed().label, Punchy.DEBUG_POSITION ? "ON" : "OFF") : String.format(Locale.ROOT, "Velocidade geral: %s (x%.1f) | Espada: %s | Blocos: %s", this.config.getSpeedPreset().label, Punchy.ANIM_SPEED, this.config.getSwordSpeed().label, this.config.getBlockPlaceSpeed().label);
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), true);
        }
    }

    private void applySpeedPreset() {
        Punchy.ANIM_SPEED = this.config.getSpeedPreset().speed;
        Punchy.BLOCK_PLACE_SPEED = this.config.getBlockPlaceSpeed().multiplier;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        drawContext.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        super.method_25394(drawContext, mouseX, mouseY, delta);
        int centerX = this.field_22789 / 2;
        int startY = this.field_22790 / 3;
        drawContext.method_27534(this.field_22793, this.field_22785, centerX, startY - 34, 0xFFFFFF);
        drawContext.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Escolha o tipo de velocidade da animacao"), centerX, startY - 20, 0xA0A0A0);
        int buttonWidth = 150;
        int buttonSpacing = 4;
        int totalWidth = buttonWidth * 3 + buttonSpacing * 2;
        int leftStart = centerX - totalWidth / 2;
        drawContext.method_25294(leftStart - 6, startY - 8, leftStart + totalWidth + 6, startY - 6, 0x40FFFFFF);
        int textY = startY + 44;
        drawContext.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"DEBUG: velocidade (x1.0)"), leftStart, textY, 0xC0C0C0);
        drawContext.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Realistic: semelhante ao vanilla (x4)"), leftStart + buttonWidth + buttonSpacing, textY, 0xC0C0C0);
        drawContext.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Punchya!: mais rapida e responsiva (x5)"), leftStart + (buttonWidth + buttonSpacing) * 2, textY, 0xC0C0C0);
        int leftX = centerX - 154;
        drawContext.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Velocidade das espadas: escolha 1x ate 5x (padrao 4x)"), leftX, startY + 76, 0xB0B0B0);
        drawContext.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Velocidade de colocar blocos: 1x ate 10x (passos de 0.5x, padrao 6x)"), leftX, startY + 100, 0xB0B0B0);
        if (this.devMode) {
            int toggleLabelY = startY + 144;
            drawContext.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Cooldown removido: golpes sempre no maximo"), leftX, toggleLabelY, 0xB0B0B0);
            drawContext.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Indicador oculto: HUD sem barra"), leftX, toggleLabelY + 24, 0xB0B0B0);
            drawContext.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Impact sincronizado: dano no keyframe"), leftX, toggleLabelY + 48, 0xB0B0B0);
            drawContext.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Debug position: ativa keybinds de ajuste (default OFF)"), leftX, toggleLabelY + 72, 0xB0B0B0);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }
}

