/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.geo.renderer;

import com.henrique.punchy.client.render.ShubbaDuckTuning;
import com.henrique.punchy.client.render.ToolTuning;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.geo.model.ShubbaDuckModel;
import com.henrique.punchy.geo.renderer.GlintAwareGeoItemRenderer;
import com.henrique.punchy.item.ShubbaDuckTotemItem;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1268;
import net.minecraft.class_4587;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public class ShubbaDuckRenderer
extends GlintAwareGeoItemRenderer<ShubbaDuckTotemItem> {
    private static final String[][] MIRRORED_BONES = new String[][]{{"shubba_duck", "shubba_duck_left"}, {"full_body", "full_body_left"}, {"head", "head_left"}, {"head2", "head2_left"}, {"bico", "bico_left"}, {"cap", "cap_left"}, {"body", "body_left"}, {"rabo", "rabo_left"}, {"wing0", "wing0_left"}, {"wing1", "wing1_left"}, {"leg0", "leg0_left"}, {"leg1", "leg1_left"}};
    private static BoneDefaults RIGHT_DEFAULTS;
    private static BoneDefaults LEFT_DEFAULTS;

    public ShubbaDuckRenderer() {
        super(new ShubbaDuckModel());
        this.withRenderLayer(new PlayerArmModelLayer<ShubbaDuckTotemItem>(this, "player_arm", false, PlayerArmModelLayer.ToolKind.SHUBBA_DUCK));
        this.withRenderLayer(new PlayerArmModelLayer<ShubbaDuckTotemItem>(this, "player_arm_left", true, PlayerArmModelLayer.ToolKind.SHUBBA_DUCK));
    }

    public void preRender(GeoRenderState state, class_4587 matrices, BakedGeoModel bakedModel, class_11659 queue, class_12075 camera, int light, int overlay, int packedOverlay) {
        super.preRender(state, matrices, bakedModel, queue, camera, light, overlay, packedOverlay);
        class_1268 hand = VanillaProxyContext.getHand();
        if (hand == null) {
            hand = class_1268.field_5808;
        }
        boolean left = hand == class_1268.field_5810;
        this.applyTuning(bakedModel, left);
        this.syncMirroredBones(bakedModel);
    }

    private void applyTuning(BakedGeoModel bakedModel, boolean left) {
        BoneDefaults defaults;
        String boneName = left ? "block_anchor_point_left" : "block_anchor_point";
        GeoBone anchor = bakedModel.getBone(boneName).orElse(null);
        if (anchor == null) {
            return;
        }
        GeoBone rightRoot = bakedModel.getBone("shubba_duck").orElse(null);
        GeoBone leftRoot = bakedModel.getBone("shubba_duck_left").orElse(null);
        if (rightRoot != null) {
            rightRoot.setHidden(left);
        }
        if (leftRoot != null) {
            leftRoot.setHidden(!left);
        }
        BoneDefaults boneDefaults = defaults = left ? LEFT_DEFAULTS : RIGHT_DEFAULTS;
        if (defaults == null) {
            defaults = new BoneDefaults(anchor.getPosX(), anchor.getPosY(), anchor.getPosZ(), anchor.getRotX(), anchor.getRotY(), anchor.getRotZ(), anchor.getScaleX(), anchor.getScaleY(), anchor.getScaleZ());
            if (left) {
                LEFT_DEFAULTS = defaults;
            } else {
                RIGHT_DEFAULTS = defaults;
            }
        }
        ToolTuning.Profile profile = ShubbaDuckTuning.get(left);
        anchor.setPosX(defaults.posX + profile.offX * 16.0f);
        anchor.setPosY(defaults.posY + profile.offY * 16.0f);
        anchor.setPosZ(defaults.posZ + profile.offZ * 16.0f);
        anchor.setRotX((float)((double)defaults.rotX + Math.toRadians(profile.rotX)));
        anchor.setRotY((float)((double)defaults.rotY + Math.toRadians(profile.rotY)));
        anchor.setRotZ((float)((double)defaults.rotZ + Math.toRadians(profile.rotZ)));
        float scale = profile.scale;
        anchor.setScaleX(defaults.scaleX * scale);
        anchor.setScaleY(defaults.scaleY * scale);
        anchor.setScaleZ(defaults.scaleZ * scale);
    }

    private void syncMirroredBones(BakedGeoModel model) {
        for (String[] pair : MIRRORED_BONES) {
            GeoBone src = model.getBone(pair[0]).orElse(null);
            GeoBone dst = model.getBone(pair[1]).orElse(null);
            if (src == null || dst == null) continue;
            dst.setRotX(src.getRotX());
            dst.setRotY(src.getRotY());
            dst.setRotZ(src.getRotZ());
            dst.setPosX(src.getPosX());
            dst.setPosY(src.getPosY());
            dst.setPosZ(src.getPosZ());
            dst.setScaleX(src.getScaleX());
            dst.setScaleY(src.getScaleY());
            dst.setScaleZ(src.getScaleZ());
        }
    }

    private record BoneDefaults(float posX, float posY, float posZ, float rotX, float rotY, float rotZ, float scaleX, float scaleY, float scaleZ) {
    }
}

