/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.networking;

import com.henrique.punchy.combat.ImpactServer;
import com.henrique.punchy.networking.packet.AxeStripPayload;
import com.henrique.punchy.networking.packet.BlockImpactPayload;
import com.henrique.punchy.networking.packet.HoeTillPayload;
import com.henrique.punchy.networking.packet.ImpactAttackPayload;
import com.henrique.punchy.networking.packet.ShovelPathPayload;
import com.henrique.punchy.server.TapMiningManager;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class ServerPacketHandlers {
    public static void handleBlockImpact(BlockImpactPayload payload, ServerPlayNetworking.Context context) {
        class_2338 pos = payload.pos();
        class_3222 player = context.player();
        MinecraftServer server = context.server();
        server.execute(() -> {
            class_3218 world = context.player().method_51469();
            TapMiningManager.onClick(context.player(), world, pos);
        });
    }

    public static void handleHoeTill(HoeTillPayload payload, ServerPlayNetworking.Context context) {
        class_2338 pos = payload.pos();
        class_3222 player = context.player();
        MinecraftServer server = context.server();
        server.execute(() -> {
            class_3218 world = context.player().method_51469();
            if (world == null) {
                return;
            }
            class_2338 above = pos.method_10084();
            if (!world.method_8320(above).method_26215()) {
                return;
            }
            class_2680 state = world.method_8320(pos);
            if (state.method_27852(class_2246.field_10253)) {
                world.method_8501(pos, class_2246.field_10566.method_9564());
                world.method_8396(null, pos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
                player.method_6047().method_71012(1, (class_1309)player, player.method_6058());
            } else if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_28685)) {
                world.method_8501(pos, class_2246.field_10362.method_9564());
                world.method_8396(null, pos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
                player.method_6047().method_71012(1, (class_1309)player, player.method_6058());
            }
        });
    }

    public static void handleAxeStrip(AxeStripPayload payload, ServerPlayNetworking.Context context) {
        class_2338 pos = payload.pos();
        class_3222 player = context.player();
        MinecraftServer server = context.server();
        server.execute(() -> {
            class_3218 world = context.player().method_51469();
            if (world == null) {
                return;
            }
            class_2680 state = world.method_8320(pos);
            StripResult copper = ServerPacketHandlers.tryCopperScrapeOrUnwax(state);
            if (copper != null) {
                world.method_8501(pos, copper.state());
                world.method_8396(null, pos, copper.sound(), class_3419.field_15245, 1.0f, 1.0f);
                player.method_6047().method_71012(1, (class_1309)player, player.method_6058());
                return;
            }
            class_2680 stripped = ServerPacketHandlers.getStrippedState(state);
            if (stripped != null) {
                world.method_8501(pos, stripped);
                world.method_8396(null, pos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
                player.method_6047().method_71012(1, (class_1309)player, player.method_6058());
            }
        });
    }

    public static void handleShovelPath(ShovelPathPayload payload, ServerPlayNetworking.Context context) {
        class_2338 pos = payload.pos();
        class_3222 player = context.player();
        MinecraftServer server = context.server();
        server.execute(() -> {
            class_3218 world = context.player().method_51469();
            if (world == null) {
                return;
            }
            class_2338 above = pos.method_10084();
            if (!world.method_8320(above).method_26215()) {
                return;
            }
            class_2680 state = world.method_8320(pos);
            if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10253) || state.method_27852(class_2246.field_28685)) {
                world.method_8501(pos, class_2246.field_10194.method_9564());
                world.method_8396(null, pos, class_3417.field_14616, class_3419.field_15245, 1.0f, 1.0f);
                try {
                    player.method_6047().method_71012(1, (class_1309)player, player.method_6058());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public static void handleImpactAttack(ImpactAttackPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        context.server().execute(() -> ImpactServer.handleImpact(player, payload));
    }

    private static class_2680 getStrippedState(class_2680 state) {
        try {
            if (state.method_27852(class_2246.field_10431)) {
                return (class_2680)class_2246.field_10519.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_10037)) {
                return (class_2680)class_2246.field_10436.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_10511)) {
                return (class_2680)class_2246.field_10366.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_10306)) {
                return (class_2680)class_2246.field_10254.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_10533)) {
                return (class_2680)class_2246.field_10622.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_10010)) {
                return (class_2680)class_2246.field_10244.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_37545)) {
                return (class_2680)class_2246.field_37548.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_42729)) {
                return (class_2680)class_2246.field_42732.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_41072)) {
                return (class_2680)class_2246.field_41073.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_10126)) {
                return (class_2680)class_2246.field_10250.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_10155)) {
                return (class_2680)class_2246.field_10558.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_10307)) {
                return (class_2680)class_2246.field_10204.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_10303)) {
                return (class_2680)class_2246.field_10084.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_9999)) {
                return (class_2680)class_2246.field_10103.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_10178)) {
                return (class_2680)class_2246.field_10374.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_37549)) {
                return (class_2680)class_2246.field_37550.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_42733)) {
                return (class_2680)class_2246.field_42730.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_22118)) {
                return (class_2680)class_2246.field_22119.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
            if (state.method_27852(class_2246.field_22111)) {
                return (class_2680)class_2246.field_22112.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static StripResult tryCopperScrapeOrUnwax(class_2680 state) {
        if (state.method_27852(class_2246.field_27133)) {
            return new StripResult(class_2246.field_27119.method_9564(), class_3417.field_29542);
        }
        if (state.method_27852(class_2246.field_27135)) {
            return new StripResult(class_2246.field_27118.method_9564(), class_3417.field_29542);
        }
        if (state.method_27852(class_2246.field_27134)) {
            return new StripResult(class_2246.field_27117.method_9564(), class_3417.field_29542);
        }
        if (state.method_27852(class_2246.field_33407)) {
            return new StripResult(class_2246.field_27116.method_9564(), class_3417.field_29542);
        }
        if (state.method_27852(class_2246.field_27116)) {
            return new StripResult(class_2246.field_27117.method_9564(), class_3417.field_29541);
        }
        if (state.method_27852(class_2246.field_27117)) {
            return new StripResult(class_2246.field_27118.method_9564(), class_3417.field_29541);
        }
        if (state.method_27852(class_2246.field_27118)) {
            return new StripResult(class_2246.field_27119.method_9564(), class_3417.field_29541);
        }
        return null;
    }

    private record StripResult(class_2680 state, class_3414 sound) {
    }
}

