/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.manors_bounty.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="manors_bounty", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ManorsBountyModLootModifier {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"manors_bounty");
    public static final RegistryObject<Codec<ManorsBountyModLootTableModifier>> LOOT_MODIFIER = LOOT_MODIFIERS.register("manors_bounty_loot_modifier", ManorsBountyModLootTableModifier.CODEC);

    @SubscribeEvent
    public static void register(FMLConstructModEvent event) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        event.enqueueWork(() -> LOOT_MODIFIERS.register(bus));
    }

    public static class ManorsBountyModLootTableModifier
    extends LootModifier {
        public static final Supplier<Codec<ManorsBountyModLootTableModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> ManorsBountyModLootTableModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ResourceLocation.f_135803_.fieldOf("lootTable").forGetter(m -> m.lootTable)).apply((Applicative)instance, ManorsBountyModLootTableModifier::new)));
        private final ResourceLocation lootTable;

        public ManorsBountyModLootTableModifier(LootItemCondition[] conditions, ResourceLocation lootTable) {
            super(conditions);
            this.lootTable = lootTable;
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            LootTable loottable = context.m_278643_().m_278676_(this.lootTable);
            ArrayList itemStacks = new ArrayList();
            loottable.m_79131_(context, itemStacks::add);
            for (int index = 0; index < generatedLoot.size(); ++index) {
                if (index >= itemStacks.size() || !(Math.random() * 100.0 > 50.0)) continue;
                generatedLoot.set(index, (Object)((ItemStack)itemStacks.get(index)));
            }
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

