/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.manors_bounty.procedures;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class DeathSickleRightClickBlockProcedure {
    public static InteractionResult execute(LevelAccessor world, double x, double y, double z, BlockState blockstate, Player player) {
        Block block = blockstate.m_60734_();
        if (blockstate.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("manors_bounty:not_harvestable")))) {
            return InteractionResult.PASS;
        }
        if (blockstate.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("manors_bounty:sickle_destroy")))) {
            return DeathSickleRightClickBlockProcedure.handleSickleDestroy(world, x, y, z, blockstate, player);
        }
        IntegerProperty ageProperty = DeathSickleRightClickBlockProcedure.getAgeProperty(blockstate);
        EnumProperty<DoubleBlockHalf> halfProperty = DeathSickleRightClickBlockProcedure.getHalfProperty(blockstate);
        if (halfProperty != null) {
            if (blockstate.m_61143_(halfProperty) == DoubleBlockHalf.LOWER) {
                return InteractionResult.PASS;
            }
            if (blockstate.m_61143_(halfProperty) == DoubleBlockHalf.UPPER) {
                return DeathSickleRightClickBlockProcedure.handleUpperHalfBlock(world, x, y, z, blockstate, player);
            }
        }
        if (ageProperty != null && (Integer)blockstate.m_61143_((Property)ageProperty) == DeathSickleRightClickBlockProcedure.getMaxAge(blockstate)) {
            BlockPos targetPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            float playerYaw = player.m_146908_();
            BlockPos offset = DeathSickleRightClickBlockProcedure.getTargetOffset(playerYaw);
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    ItemStack itemStack;
                    IntegerProperty checkAgeProperty;
                    BlockPos checkPos = targetPos.m_7918_(offset.m_123341_() + dx, 0, offset.m_123343_() + dz);
                    BlockState checkBlockState = world.m_8055_(checkPos);
                    if (checkBlockState.m_60734_() != block || (checkAgeProperty = DeathSickleRightClickBlockProcedure.getAgeProperty(checkBlockState)) == null || (Integer)checkBlockState.m_61143_((Property)checkAgeProperty) != DeathSickleRightClickBlockProcedure.getMaxAge(checkBlockState)) continue;
                    DeathSickleRightClickBlockProcedure.resetBlockState(world, checkPos, checkBlockState);
                    DeathSickleRightClickBlockProcedure.dropItem(world, checkPos, block, checkBlockState);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        BlockPos pos = checkPos;
                        serverLevel.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.beehive.shear")), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    if (player.m_7500_() || !(itemStack = player.m_21205_()).m_41763_()) continue;
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult handleUpperHalfBlock(LevelAccessor world, double x, double y, double z, BlockState blockstate, Player player) {
        Block block = blockstate.m_60734_();
        IntegerProperty ageProperty = DeathSickleRightClickBlockProcedure.getAgeProperty(blockstate);
        if (ageProperty != null && (Integer)blockstate.m_61143_((Property)ageProperty) == DeathSickleRightClickBlockProcedure.getMaxAge(blockstate)) {
            BlockPos targetPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            float playerYaw = player.m_146908_();
            BlockPos offset = DeathSickleRightClickBlockProcedure.getTargetOffset(playerYaw);
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    ItemStack itemStack;
                    IntegerProperty checkAgeProperty;
                    BlockPos checkPos = targetPos.m_7918_(offset.m_123341_() + dx, 0, offset.m_123343_() + dz);
                    BlockState checkBlockState = world.m_8055_(checkPos);
                    if (checkBlockState.m_60734_() != block || (checkAgeProperty = DeathSickleRightClickBlockProcedure.getAgeProperty(checkBlockState)) == null || (Integer)checkBlockState.m_61143_((Property)checkAgeProperty) != DeathSickleRightClickBlockProcedure.getMaxAge(checkBlockState)) continue;
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        serverLevel.m_46961_(checkPos, true);
                        serverLevel.m_5594_(null, checkPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.beehive.shear")), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    if (player.m_7500_() || !(itemStack = player.m_21205_()).m_41763_()) continue;
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult handleSickleDestroy(LevelAccessor world, double x, double y, double z, BlockState blockstate, Player player) {
        Block block = blockstate.m_60734_();
        BlockPos targetPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        float playerYaw = player.m_146908_();
        BlockPos offset = DeathSickleRightClickBlockProcedure.getTargetOffset(playerYaw);
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                ItemStack itemStack;
                BlockPos checkPos = targetPos.m_7918_(offset.m_123341_() + dx, 0, offset.m_123343_() + dz);
                BlockState checkBlockState = world.m_8055_(checkPos);
                if (checkBlockState.m_60734_() != block) continue;
                IntegerProperty checkAgeProperty = DeathSickleRightClickBlockProcedure.getAgeProperty(checkBlockState);
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    serverLevel.m_46961_(checkPos, true);
                    serverLevel.m_5594_(null, checkPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.beehive.shear")), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (player.m_7500_() || !(itemStack = player.m_21205_()).m_41763_()) continue;
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private static IntegerProperty getAgeProperty(BlockState state) {
        IntegerProperty ip;
        Property property = state.m_60734_().m_49965_().m_61081_("age");
        return property instanceof IntegerProperty ? (ip = (IntegerProperty)property) : null;
    }

    private static int getMaxAge(BlockState state) {
        IntegerProperty ageProperty = DeathSickleRightClickBlockProcedure.getAgeProperty(state);
        if (ageProperty != null) {
            return ageProperty.m_6908_().stream().max(Integer::compareTo).orElse(0);
        }
        return 0;
    }

    private static BlockPos getTargetOffset(float yaw) {
        int xOffset = 0;
        int zOffset = 0;
        if (yaw >= -45.0f && yaw < 45.0f) {
            zOffset = 2;
        } else if (yaw >= 45.0f && yaw < 135.0f) {
            xOffset = -2;
        } else if (yaw >= 135.0f || yaw < -135.0f) {
            zOffset = -2;
        } else if (yaw >= -135.0f && yaw < -45.0f) {
            xOffset = 2;
        }
        return new BlockPos(xOffset, 0, zOffset);
    }

    private static void resetBlockState(LevelAccessor world, BlockPos pos, BlockState blockstate) {
        IntegerProperty ageProperty = DeathSickleRightClickBlockProcedure.getAgeProperty(blockstate);
        if (ageProperty != null) {
            BlockState newState = (BlockState)blockstate.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(0));
            world.m_7731_(pos, newState, 3);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                serverLevel.m_7260_(pos, blockstate, newState, 3);
            }
        }
    }

    private static EnumProperty<DoubleBlockHalf> getHalfProperty(BlockState state) {
        return state.m_60734_().m_49965_().m_61081_("half") instanceof EnumProperty ? (EnumProperty)state.m_60734_().m_49965_().m_61081_("half") : null;
    }

    private static void dropItem(LevelAccessor world, BlockPos pos, Block block, BlockState blockstate) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            List drops = Block.m_49869_((BlockState)blockstate, (ServerLevel)serverLevel, (BlockPos)pos, null);
            for (ItemStack stack : drops) {
                ItemEntity entityToSpawn = new ItemEntity((Level)serverLevel, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
                entityToSpawn.m_32010_(10);
                serverLevel.m_7967_((Entity)entityToSpawn);
            }
        }
    }
}

