/*
 * Decompiled with CFR 0.152.
 */
package com.min01.tickrateapi.capabilities;

import com.min01.tickrateapi.capabilities.ITickrateCapability;
import com.min01.tickrateapi.network.TickrateNetwork;
import com.min01.tickrateapi.network.UpdateTickratePacket;
import com.min01.tickrateapi.util.CustomTimer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;

public class TickrateCapabilityImpl
implements ITickrateCapability {
    private CustomTimer baseTimer = new CustomTimer(20.0f, 0L);
    private CustomTimer currentTimer = new CustomTimer(20.0f, 0L);
    private Entity entity;
    private boolean excluded;
    private boolean excludeSubEntities;
    private boolean shouldChangeSubEntities = true;
    private float baseTickrate = 20.0f;
    private float tickrate = 20.0f;
    private int tick = 21;

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("CurrentTickrate", this.currentTimer.tickrate);
        nbt.m_128350_("BaseTickrate", this.baseTimer.tickrate);
        nbt.m_128350_("Tickrate", this.tickrate);
        nbt.m_128350_("Tick", (float)this.tick);
        nbt.m_128379_("ChangeSubEntities", this.shouldChangeSubEntities);
        nbt.m_128379_("Excluded", this.excluded);
        nbt.m_128379_("ExcludeSubEntities", this.excludeSubEntities);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.currentTimer.setTickrate(nbt.m_128457_("CurrentTickrate"));
        this.baseTimer.setTickrate(nbt.m_128457_("BaseTickrate"));
        this.tickrate = nbt.m_128457_("Tickrate");
        this.tick = nbt.m_128451_("Tick");
        this.shouldChangeSubEntities = nbt.m_128471_("ChangeSubEntities");
        this.excluded = nbt.m_128471_("Excluded");
        this.excludeSubEntities = nbt.m_128471_("ExcludeSubEntities");
    }

    @Override
    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void setBaseTickrate(float tickrate) {
        this.tick = 0;
        this.baseTickrate = tickrate;
        this.tickrate = tickrate;
        this.baseTimer.setTickrate(tickrate);
        this.currentTimer.setTickrate(tickrate);
        this.sendUpdatePacket(false);
    }

    @Override
    public void setTickrate(float tickrate) {
        this.tick = 0;
        this.tickrate = tickrate;
        this.currentTimer.setTickrate(tickrate);
        this.sendUpdatePacket(false);
    }

    @Override
    public float getTickrate() {
        return this.tickrate;
    }

    @Override
    public void resetTickrate() {
        this.currentTimer.setTickrate(20.0f);
        this.baseTimer.setTickrate(20.0f);
        this.baseTickrate = 20.0f;
        this.tickrate = 20.0f;
        this.tick = 21;
        this.sendUpdatePacket(true);
    }

    @Override
    public void tick() {
        if (!this.entity.f_19853_.f_46443_ && this.baseTimer.tickrate == 20.0f) {
            ++this.tick;
            this.sendUpdatePacket(false);
        }
        this.baseTimer.setTick(this.tick);
        this.currentTimer.setTick(this.tick);
        this.currentTimer.setTickrate(this.baseTimer.tickrate);
        this.tickrate = this.baseTickrate;
    }

    @Override
    public void forceTick() {
        this.sendUpdatePacket(false);
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public CustomTimer getBaseTimer() {
        return this.baseTimer;
    }

    @Override
    public CustomTimer getCurrentTimer() {
        return this.currentTimer;
    }

    @Override
    public void exclude(boolean flag) {
        this.excluded = flag;
        this.sendUpdatePacket(false);
    }

    @Override
    public boolean isExcluded() {
        return this.excluded;
    }

    @Override
    public void excludeSubEntities(boolean flag) {
        this.excludeSubEntities = flag;
        this.sendUpdatePacket(false);
    }

    @Override
    public void changeSubEntities(boolean flag) {
        this.shouldChangeSubEntities = flag;
        this.sendUpdatePacket(false);
    }

    @Override
    public boolean shouldExcludeSubEntities() {
        return this.excludeSubEntities;
    }

    @Override
    public boolean shouldChangeSubEntities() {
        return this.shouldChangeSubEntities;
    }

    @Override
    public boolean hasTimer() {
        return this.tick <= 20;
    }

    @Override
    public void sync(boolean excluded, boolean excludeSubEntities, boolean changeSubEntities, float baseTickrate, float currentTickrate, int tick) {
        this.excluded = excluded;
        this.excludeSubEntities = excludeSubEntities;
        this.shouldChangeSubEntities = changeSubEntities;
        this.baseTimer.setTickrate(baseTickrate);
        this.baseTickrate = baseTickrate;
        this.currentTimer.setTickrate(currentTickrate);
        this.tickrate = currentTickrate;
        this.tick = tick;
    }

    private void sendUpdatePacket(boolean reset) {
        if (!this.entity.f_19853_.f_46443_) {
            TickrateNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.entity), (Object)new UpdateTickratePacket(this.entity.m_20148_(), this, reset));
        }
    }
}

