/*
 * Decompiled with CFR 0.152.
 */
package com.min01.tickrateapi.command;

import com.min01.tickrateapi.util.TickrateUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SetTickrateCommand {
    public static void register(CommandDispatcher<CommandSourceStack> p_214446_) {
        p_214446_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setTickrate").requires(p_137777_ -> p_137777_.m_6761_(2))).then(Commands.m_82127_((String)"entity").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"tickrate", (ArgumentType)FloatArgumentType.floatArg()).executes(p_137810_ -> SetTickrateCommand.setEntityTickrate((CommandSourceStack)p_137810_.getSource(), EntityArgument.m_91461_((CommandContext)p_137810_, (String)"targets"), FloatArgumentType.getFloat((CommandContext)p_137810_, (String)"tickrate"))))))).then(Commands.m_82127_((String)"dimension").then(Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"tickrate", (ArgumentType)FloatArgumentType.floatArg()).executes(p_137810_ -> SetTickrateCommand.setLevelTickrate((CommandSourceStack)p_137810_.getSource(), DimensionArgument.m_88808_((CommandContext)p_137810_, (String)"world"), FloatArgumentType.getFloat((CommandContext)p_137810_, (String)"tickrate"))))))).then(Commands.m_82127_((String)"exclude").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"exclude", (ArgumentType)BoolArgumentType.bool()).executes(p_137810_ -> SetTickrateCommand.excludeEntities((CommandSourceStack)p_137810_.getSource(), EntityArgument.m_91461_((CommandContext)p_137810_, (String)"targets"), BoolArgumentType.getBool((CommandContext)p_137810_, (String)"exclude"))))))).then(Commands.m_82127_((String)"area").then(Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"pos1", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"pos2", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"tickrate", (ArgumentType)FloatArgumentType.floatArg()).executes(p_137810_ -> SetTickrateCommand.addTickrateArea((CommandSourceStack)p_137810_.getSource(), DimensionArgument.m_88808_((CommandContext)p_137810_, (String)"world"), Vec3Argument.m_120844_((CommandContext)p_137810_, (String)"pos1"), Vec3Argument.m_120844_((CommandContext)p_137810_, (String)"pos2"), FloatArgumentType.getFloat((CommandContext)p_137810_, (String)"tickrate")))))))));
    }

    private static int addTickrateArea(CommandSourceStack source, ServerLevel serverLevel, Vec3 pos1, Vec3 pos2, float tickrate) {
        TickrateUtil.addTickrateArea((ResourceKey<Level>)serverLevel.m_46472_(), new AABB(pos1, pos2), tickrate);
        if (tickrate == 20.0f) {
            source.m_288197_(() -> Component.m_237113_((String)("Removed tickrate area in " + serverLevel.m_46472_().m_135782_().toString())), true);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)("Added new tickrate area in " + serverLevel.m_46472_().m_135782_().toString() + " with " + tickrate + " tickrate")), true);
        }
        return 0;
    }

    private static int excludeEntities(CommandSourceStack source, Collection<? extends Entity> entities, boolean exclude) {
        for (Entity entity : entities) {
            if (exclude) {
                TickrateUtil.excludeEntity(entity, true);
                source.m_288197_(() -> Component.m_237113_((String)("Excluded " + entity.m_5446_().getString() + " from dimension tickrate")), true);
                continue;
            }
            TickrateUtil.includeEntity(entity);
            source.m_288197_(() -> Component.m_237113_((String)("Included " + entity.m_5446_().getString() + " from dimension tickrate")), true);
        }
        return entities.size();
    }

    private static int setLevelTickrate(CommandSourceStack source, ServerLevel serverLevel, float tickrate) {
        TickrateUtil.setLevelTickrate((ResourceKey<Level>)serverLevel.m_46472_(), tickrate);
        if (tickrate == 20.0f) {
            source.m_288197_(() -> Component.m_237113_((String)("Reseted Tickrate of " + serverLevel.m_46472_().m_135782_().toString() + " to " + tickrate)), true);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)("Changed Tickrate of " + serverLevel.m_46472_().m_135782_().toString() + " to " + tickrate)), true);
        }
        return 0;
    }

    private static int setEntityTickrate(CommandSourceStack source, Collection<? extends Entity> entities, float tickrate) {
        for (Entity entity : entities) {
            if (tickrate == 20.0f) {
                TickrateUtil.resetTickrate(entity);
                source.m_288197_(() -> Component.m_237113_((String)("Reseted Tickrate of " + entity.m_5446_().getString())), true);
                continue;
            }
            TickrateUtil.setBaseTickrate(entity, tickrate);
            source.m_288197_(() -> Component.m_237113_((String)("Changed Tickrate of " + entity.m_5446_().getString() + " to " + tickrate)), true);
        }
        return entities.size();
    }
}

