/*
 * Decompiled with CFR 0.152.
 */
package com.min01.tickrateapi.mixin;

import com.min01.tickrateapi.config.TimerConfig;
import com.min01.tickrateapi.util.CustomTimer;
import com.min01.tickrateapi.util.ITime;
import com.min01.tickrateapi.util.TickrateUtil;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientLevel
extends Level
implements ITime {
    private int time;
    private int normalTime;
    private final CustomTimer dimensionTimer = new CustomTimer(20.0f, 0L);

    protected MixinClientLevel(WritableLevelData p_220352_, ResourceKey<Level> p_220353_, RegistryAccess p_270200_, Holder<DimensionType> p_220354_, Supplier<ProfilerFiller> p_220355_, boolean p_220356_, boolean p_220357_, long p_220358_, int p_220359_) {
        super(p_220352_, p_220353_, p_270200_, p_220354_, p_220355_, p_220356_, p_220357_, p_220358_, p_220359_);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"}, cancellable=true)
    private void tick(BooleanSupplier supplier, CallbackInfo ci) {
        if (TickrateUtil.hasDimensionTimer((ResourceKey<Level>)this.m_46472_())) {
            CustomTimer timer = TickrateUtil.getDimensionTimer((ResourceKey<Level>)this.m_46472_());
            this.time = timer.advanceTime(Util.m_137550_());
        }
        this.normalTime = this.dimensionTimer.advanceTime(Util.m_137550_());
    }

    @Inject(at={@At(value="HEAD")}, method={"tickNonPassenger"}, cancellable=true)
    private void tickNonPassenger(Entity p_104640_, CallbackInfo ci) {
        block7: {
            block6: {
                if (p_104640_ instanceof Player) {
                    return;
                }
                if (!TickrateUtil.hasTimer(p_104640_)) break block6;
                ci.cancel();
                CustomTimer timer = TickrateUtil.getTimer(p_104640_);
                int j = timer.advanceTime(Util.m_137550_());
                for (int k = 0; k < Math.min((Boolean)TimerConfig.disableTickrateLimit.get() != false ? 500 : 10, j); ++k) {
                    this.tickEntities(p_104640_);
                }
                break block7;
            }
            if (!TickrateUtil.hasDimensionTimer((ResourceKey<Level>)this.m_46472_())) break block7;
            if (!TickrateUtil.isExcluded(p_104640_)) {
                ci.cancel();
                int j = this.time;
                for (int k = 0; k < Math.min((Boolean)TimerConfig.disableTickrateLimit.get() != false ? 500 : 10, j); ++k) {
                    this.tickEntities(p_104640_);
                }
            } else {
                ci.cancel();
                int j = this.normalTime;
                for (int k = 0; k < Math.min((Boolean)TimerConfig.disableTickrateLimit.get() != false ? 500 : 10, j); ++k) {
                    this.tickEntities(p_104640_);
                }
            }
        }
    }

    @Unique
    private void tickEntities(Entity p_104640_) {
        p_104640_.m_146867_();
        ++p_104640_.f_19797_;
        this.m_46473_().m_6521_(() -> BuiltInRegistries.f_256780_.m_7981_((Object)p_104640_.m_6095_()).toString());
        if (p_104640_.canUpdate()) {
            p_104640_.m_8119_();
        }
        this.m_46473_().m_7238_();
        for (Entity entity : p_104640_.m_20197_()) {
            this.m_104641_(p_104640_, entity);
        }
    }

    @Shadow
    private void m_104641_(Entity p_104642_, Entity p_104643_) {
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int time) {
        this.time = time;
    }
}

