/*
 * Decompiled with CFR 0.152.
 */
package com.min01.tickrateapi.mixin;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Lists;
import com.min01.tickrateapi.config.TimerConfig;
import com.min01.tickrateapi.util.CustomTimer;
import com.min01.tickrateapi.util.ITime;
import com.min01.tickrateapi.util.TickrateUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class})
public class MixinParticleEngine {
    @Shadow
    protected ClientLevel f_107287_;
    @Shadow
    @Final
    private Map<ParticleRenderType, Queue<Particle>> f_107289_;
    @Shadow
    @Final
    private Queue<TrackingEmitter> f_107290_;
    @Shadow
    @Final
    private Queue<Particle> f_107294_;
    @Unique
    private final CustomTimer timer = new CustomTimer(20.0f, 0L);

    @Inject(at={@At(value="HEAD")}, method={"tick"}, cancellable=true)
    private void tick(CallbackInfo ci) {
        if (TickrateUtil.hasDimensionTimer((ResourceKey<Level>)this.f_107287_.m_46472_()) && TickrateUtil.isExcluded((Entity)Minecraft.m_91087_().f_91074_)) {
            ci.cancel();
            int j = ((ITime)this.f_107287_).getTime();
            for (int k = 0; k < Math.min((Boolean)TimerConfig.disableTickrateLimit.get() != false ? 500 : 10, j); ++k) {
                Particle particle;
                this.f_107289_.forEach((p_288249_, p_288250_) -> {
                    this.f_107287_.m_46473_().m_6180_(p_288249_.toString());
                    this.m_107384_((Collection<Particle>)p_288250_);
                    this.f_107287_.m_46473_().m_7238_();
                });
                if (!this.f_107290_.isEmpty()) {
                    ArrayList list = Lists.newArrayList();
                    for (TrackingEmitter trackingemitter : this.f_107290_) {
                        trackingemitter.m_5989_();
                        if (trackingemitter.m_107276_()) continue;
                        list.add(trackingemitter);
                    }
                    this.f_107290_.removeAll(list);
                }
                if (this.f_107294_.isEmpty()) continue;
                while ((particle = this.f_107294_.poll()) != null) {
                    this.f_107289_.computeIfAbsent(particle.m_7556_(), p_107347_ -> EvictingQueue.create((int)16384)).add(particle);
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tickParticleList"}, cancellable=true)
    private void tickParticleList(Collection<Particle> particles, CallbackInfo ci) {
        if (!particles.isEmpty()) {
            Iterator<Particle> iterator = particles.iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                Vec3 pos = new Vec3(particle.f_107212_, particle.f_107213_, particle.f_107212_);
                AABB aabb = new AABB(pos, pos).m_82400_(1.0);
                Pair<Boolean, Float> pair = TickrateUtil.getArea((ResourceKey<Level>)this.f_107287_.m_46472_(), aabb);
                if (!((Boolean)pair.getLeft()).booleanValue()) continue;
                ci.cancel();
                this.timer.setTickrate(((Float)pair.getRight()).floatValue());
                int j = this.timer.advanceTime(Util.m_137550_());
                for (int k = 0; k < Math.min((Boolean)TimerConfig.disableTickrateLimit.get() != false ? 500 : 10, j); ++k) {
                    this.m_107393_(particle);
                }
                if (particle.m_107276_()) continue;
                particle.m_142654_().ifPresent(p_172289_ -> this.m_172281_((ParticleGroup)p_172289_, -1));
                iterator.remove();
            }
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/particle/Particle;render(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/client/Camera;F)V"), method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/Camera;FLnet/minecraft/client/renderer/culling/Frustum;)V"})
    private void render(Particle instance, VertexConsumer p_107261_, Camera p_107262_, float p_107263_) {
        if (TickrateUtil.hasDimensionTimer((ResourceKey<Level>)this.f_107287_.m_46472_()) && TickrateUtil.isExcluded((Entity)Minecraft.m_91087_().f_91074_)) {
            instance.m_5744_(p_107261_, p_107262_, TickrateUtil.getDimensionTimer((ResourceKey<Level>)this.f_107287_.m_46472_()).partialTick);
        } else {
            instance.m_5744_(p_107261_, p_107262_, p_107263_);
        }
    }

    @Shadow
    private void m_107384_(Collection<Particle> particles) {
    }

    @Shadow
    private void m_172281_(ParticleGroup p_172282_, int p_172283_) {
    }

    @Shadow
    private void m_107393_(Particle p_107394_) {
    }
}

