/*
 * Decompiled with CFR 0.152.
 */
package com.min01.tickrateapi.mixin;

import com.min01.tickrateapi.capabilities.ITickrateCapability;
import com.min01.tickrateapi.capabilities.TickrateCapabilities;
import com.min01.tickrateapi.util.CustomTimer;
import com.min01.tickrateapi.util.TickrateUtil;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public abstract class MixinServerLevel
extends Level {
    protected MixinServerLevel(WritableLevelData p_220352_, ResourceKey<Level> p_220353_, RegistryAccess p_270200_, Holder<DimensionType> p_220354_, Supplier<ProfilerFiller> p_220355_, boolean p_220356_, boolean p_220357_, long p_220358_, int p_220359_) {
        super(p_220352_, p_220353_, p_270200_, p_220354_, p_220355_, p_220356_, p_220357_, p_220358_, p_220359_);
    }

    @Inject(at={@At(value="HEAD")}, method={"addFreshEntity"})
    private void addFreshEntity(Entity p_8837_, CallbackInfoReturnable<Boolean> ci) {
        Class<?>[] ctx;
        MySecurityManager manager = new MySecurityManager();
        for (Class<?> clazz : ctx = manager.getContext()) {
            Entity entity;
            if (TickrateUtil.ENTITY_MAP.containsKey(clazz.hashCode())) {
                entity = TickrateUtil.ENTITY_MAP.get(clazz.hashCode());
                if (entity == null) continue;
                if (TickrateUtil.hasTimer(entity) && TickrateUtil.shouldChangeSubEntities(entity)) {
                    TickrateUtil.setBaseTickrate(p_8837_, TickrateUtil.getTickrate(entity));
                }
                if (!TickrateUtil.isExcluded(entity) || !TickrateUtil.shouldExcludeSubEntities(entity)) continue;
                TickrateUtil.excludeEntity(p_8837_);
                continue;
            }
            if (!TickrateUtil.ENTITY_MAP2.containsKey(clazz.hashCode()) || (entity = TickrateUtil.ENTITY_MAP2.get(clazz.hashCode())) == null) continue;
            if (TickrateUtil.hasTimer(entity) && TickrateUtil.shouldChangeSubEntities(entity)) {
                TickrateUtil.setBaseTickrate(p_8837_, TickrateUtil.getTickrate(entity));
            }
            if (!TickrateUtil.isExcluded(entity) || !TickrateUtil.shouldExcludeSubEntities(entity)) continue;
            TickrateUtil.excludeEntity(p_8837_);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"}, cancellable=true)
    private void tick(BooleanSupplier supplier, CallbackInfo ci) {
        if (TickrateUtil.hasDimensionTimer((ResourceKey<Level>)this.m_46472_())) {
            this.tickDimensionTimer();
        }
    }

    public void tickEntityTimer(CustomTimer timer, Entity entity) {
        float tickrate = timer.tickrate;
        if (tickrate < 0.0f) {
            tickrate = 0.0f;
        }
        timer.accumulator += tickrate / 20.0f;
        int logicTicks = (int)timer.accumulator;
        if (logicTicks >= 1) {
            timer.canTick = true;
            timer.accumulator -= (float)logicTicks;
            timer.pendingTicks = logicTicks;
        } else {
            timer.canTick = false;
        }
    }

    public void tickDimensionTimer() {
        CustomTimer timer = TickrateUtil.getDimensionTimer((ResourceKey<Level>)this.m_46472_());
        float tickrate = timer.tickrate;
        if (tickrate < 0.0f) {
            tickrate = 0.0f;
        }
        timer.accumulator += tickrate / 20.0f;
        int logicTicks = (int)timer.accumulator;
        if (logicTicks >= 1) {
            timer.canTick = true;
            timer.accumulator -= (float)logicTicks;
            timer.pendingTicks = logicTicks;
        } else {
            timer.canTick = false;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tickNonPassenger"}, cancellable=true)
    private void tickNonPassenger(Entity p_8648_, CallbackInfo ci) {
        block5: {
            block4: {
                if (!TickrateUtil.hasTimer(p_8648_)) break block4;
                ci.cancel();
                CustomTimer timer = TickrateUtil.getTimer(p_8648_);
                this.tickEntityTimer(timer, p_8648_);
                p_8648_.getCapability(TickrateCapabilities.TICKRATE).ifPresent(ITickrateCapability::forceTick);
                if (!timer.canTick) break block5;
                int tick = timer.pendingTicks;
                for (int i = 0; i < tick; ++i) {
                    this.tickEntities(p_8648_);
                }
                break block5;
            }
            if (TickrateUtil.hasDimensionTimer((ResourceKey<Level>)this.m_46472_()) && !TickrateUtil.isExcluded(p_8648_)) {
                ci.cancel();
                CustomTimer timer = TickrateUtil.getDimensionTimer((ResourceKey<Level>)this.m_46472_());
                if (timer.canTick) {
                    int tick = timer.pendingTicks;
                    for (int i = 0; i < tick; ++i) {
                        this.tickEntities(p_8648_);
                    }
                }
            }
        }
    }

    @Unique
    private void tickEntities(Entity p_8648_) {
        p_8648_.m_146867_();
        ProfilerFiller profilerfiller = this.m_46473_();
        ++p_8648_.f_19797_;
        this.m_46473_().m_6521_(() -> BuiltInRegistries.f_256780_.m_7981_((Object)p_8648_.m_6095_()).toString());
        profilerfiller.m_6174_("tickNonPassenger");
        p_8648_.m_8119_();
        this.m_46473_().m_7238_();
        for (Entity entity : p_8648_.m_20197_()) {
            this.m_8662_(p_8648_, entity);
        }
    }

    @Shadow
    private void m_8662_(Entity p_104642_, Entity p_104643_) {
    }

    private static class MySecurityManager
    extends SecurityManager {
        private MySecurityManager() {
        }

        public Class<?>[] getContext() {
            return this.getClassContext();
        }
    }
}

