/*
 * Decompiled with CFR 0.152.
 */
package com.min01.tickrateapi.network;

import com.min01.tickrateapi.util.TickrateUtil;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class UpdateAreaTickratePacket {
    private final AABB aabb;
    private final float tickrate;

    public UpdateAreaTickratePacket(AABB aabb, float tickrate) {
        this.aabb = aabb;
        this.tickrate = tickrate;
    }

    public UpdateAreaTickratePacket(FriendlyByteBuf buf) {
        this.aabb = new AABB(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.tickrate = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.aabb.f_82288_);
        buf.writeDouble(this.aabb.f_82289_);
        buf.writeDouble(this.aabb.f_82290_);
        buf.writeDouble(this.aabb.f_82291_);
        buf.writeDouble(this.aabb.f_82292_);
        buf.writeDouble(this.aabb.f_82293_);
        buf.writeFloat(this.tickrate);
    }

    public static class Handler {
        public static boolean onMessage(UpdateAreaTickratePacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    ((Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide())).filter(ClientLevel.class::isInstance).ifPresent(t -> {
                        if (message.tickrate == 20.0f) {
                            Iterator<Pair<AABB, Float>> itr = TickrateUtil.AABB_LIST.iterator();
                            while (itr.hasNext()) {
                                Pair<AABB, Float> next = itr.next();
                                if (!((AABB)next.getLeft()).equals((Object)message.aabb)) continue;
                                itr.remove();
                            }
                        } else {
                            TickrateUtil.AABB_LIST.add((Pair<AABB, Float>)Pair.of((Object)message.aabb, (Object)Float.valueOf(message.tickrate)));
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

