/*
 * Decompiled with CFR 0.152.
 */
package com.min01.tickrateapi.network;

import com.min01.tickrateapi.capabilities.ITickrateCapability;
import com.min01.tickrateapi.capabilities.TickrateCapabilities;
import com.min01.tickrateapi.capabilities.TickrateCapabilityImpl;
import com.min01.tickrateapi.util.TickrateUtil;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;

public class UpdateTickratePacket {
    private final UUID uuid;
    private final ITickrateCapability cap;
    private final boolean reset;

    public UpdateTickratePacket(UUID uuid, ITickrateCapability cap, boolean reset) {
        this.uuid = uuid;
        this.cap = cap;
        this.reset = reset;
    }

    public UpdateTickratePacket(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        TickrateCapabilityImpl cap = new TickrateCapabilityImpl();
        cap.deserializeNBT((Tag)buf.m_130260_());
        this.cap = cap;
        this.reset = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.m_130079_((CompoundTag)this.cap.serializeNBT());
        buf.writeBoolean(this.reset);
    }

    public static class Handler {
        public static boolean onMessage(UpdateTickratePacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    ((Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide())).filter(ClientLevel.class::isInstance).ifPresent(t -> {
                        Object entity = TickrateUtil.getEntityByUUID(t, message.uuid);
                        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
                        if (message.reset) {
                            cap.resetTickrate();
                        } else {
                            cap.sync(message.cap.isExcluded(), message.cap.shouldChangeSubEntities(), message.cap.shouldExcludeSubEntities(), message.cap.getBaseTimer().tickrate, message.cap.getCurrentTimer().tickrate, message.cap.getTick());
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

