/*
 * Decompiled with CFR 0.152.
 */
package com.min01.tickrateapi.util;

import com.min01.tickrateapi.capabilities.ITickrateCapability;
import com.min01.tickrateapi.capabilities.TickrateCapabilities;
import com.min01.tickrateapi.capabilities.TickrateCapabilityImpl;
import com.min01.tickrateapi.command.SetTickrateCommand;
import com.min01.tickrateapi.network.TickrateNetwork;
import com.min01.tickrateapi.network.UpdateAreaTickratePacket;
import com.min01.tickrateapi.network.UpdateDimensionTickratePacket;
import com.min01.tickrateapi.util.CustomTimer;
import com.min01.tickrateapi.world.TickrateSavedData;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="tickrateapi", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TickrateUtil {
    public static final Method GET_ENTITY = ObfuscationReflectionHelper.findMethod(Level.class, (String)"m_142646_", (Class[])new Class[0]);
    public static final Map<Integer, Entity> ENTITY_MAP = new HashMap<Integer, Entity>();
    public static final Map<Integer, Entity> ENTITY_MAP2 = new HashMap<Integer, Entity>();
    public static final Map<ResourceKey<Level>, CustomTimer> LEVEL_MAP = new HashMap<ResourceKey<Level>, CustomTimer>();
    public static final List<Pair<AABB, Float>> AABB_LIST = new ArrayList<Pair<AABB, Float>>();

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        SetTickrateCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onLevelLoadEvent(LevelEvent.Load event) {
        ResourceKey dimension = ((Level)event.getLevel()).m_46472_();
        TickrateSavedData data = TickrateSavedData.get((ResourceKey<Level>)dimension);
        if (data != null) {
            TickrateNetwork.sendToAll(new UpdateDimensionTickratePacket((ResourceKey<Level>)dimension, data.getTimer().tickrate));
            data.getTickrateAreas().forEach(t -> TickrateNetwork.sendToAll(new UpdateAreaTickratePacket((AABB)t.getLeft(), ((Float)t.getRight()).floatValue())));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        ENTITY_MAP.put(entity.getClass().hashCode(), entity);
        ENTITY_MAP2.put(entity.getClass().getSuperclass().hashCode(), entity);
    }

    public static boolean hasDimensionTimer(ResourceKey<Level> dimension) {
        TickrateSavedData data = TickrateSavedData.get(dimension);
        if (data != null) {
            return data.getTimer().tickrate != 20.0f;
        }
        return LEVEL_MAP.containsKey(dimension) && TickrateUtil.LEVEL_MAP.get(dimension).tickrate != 20.0f;
    }

    public static CustomTimer getDimensionTimer(ResourceKey<Level> dimension) {
        TickrateSavedData data = TickrateSavedData.get(dimension);
        if (data != null) {
            return data.getTimer();
        }
        return LEVEL_MAP.get(dimension);
    }

    public static boolean isExcluded(Entity entity) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        return cap.isExcluded();
    }

    public static boolean shouldChangeSubEntities(Entity entity) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        return cap.shouldChangeSubEntities();
    }

    public static boolean shouldExcludeSubEntities(Entity entity) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        return cap.shouldExcludeSubEntities();
    }

    public static List<Pair<AABB, Float>> getTickrateAreas(ResourceKey<Level> dimension) {
        TickrateSavedData data = TickrateSavedData.get(dimension);
        if (data != null) {
            return data.getTickrateAreas();
        }
        return AABB_LIST;
    }

    public static void addTickrateArea(ResourceKey<Level> dimension, AABB aabb, float tickrate) {
        TickrateSavedData data = TickrateSavedData.get(dimension);
        if (data != null) {
            data.addTickrateArea(aabb, tickrate);
            TickrateNetwork.sendToAll(new UpdateAreaTickratePacket(aabb, tickrate));
        }
    }

    public static void setLevelTickrate(ResourceKey<Level> dimension, float tickrate) {
        TickrateSavedData data = TickrateSavedData.get(dimension);
        if (data != null) {
            data.setTickrate(tickrate);
            TickrateNetwork.sendToAll(new UpdateDimensionTickratePacket(dimension, tickrate));
        }
    }

    public static void includeEntity(Entity entity) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        cap.exclude(false);
    }

    public static void excludeEntity(Entity entity) {
        TickrateUtil.excludeEntity(entity, true);
    }

    public static void excludeEntity(Entity entity, boolean excludeSubEntities) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        cap.exclude(true);
        cap.excludeSubEntities(excludeSubEntities);
    }

    public static void changeSubEntities(Entity entity, boolean changeSubEntities) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        cap.changeSubEntities(changeSubEntities);
    }

    public static void setBaseTickrate(Entity entity, float tickrate) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        cap.setBaseTickrate(tickrate);
    }

    public static void setTickrate(Entity entity, float tickrate) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        cap.setTickrate(tickrate);
    }

    public static float getTickrate(Entity entity) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        return cap.getTickrate();
    }

    public static void resetTickrate(Entity entity) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        cap.resetTickrate();
    }

    public static CustomTimer getBaseTimer(Entity entity) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        return cap.getBaseTimer();
    }

    public static CustomTimer getTimer(Entity entity) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        return cap.getCurrentTimer();
    }

    public static boolean hasTimer(Entity entity) {
        ITickrateCapability cap = (ITickrateCapability)entity.getCapability(TickrateCapabilities.TICKRATE).orElse((Object)new TickrateCapabilityImpl());
        return cap.hasTimer();
    }

    public static float getTickRateAt(ResourceKey<Level> dimension, Vec3 pos) {
        for (Pair<AABB, Float> pair : TickrateUtil.getTickrateAreas(dimension)) {
            AABB aabb = (AABB)pair.getLeft();
            if (!aabb.m_82390_(pos)) continue;
            return ((Float)pair.getRight()).floatValue();
        }
        return 20.0f;
    }

    public static Pair<Boolean, Float> getArea(ResourceKey<Level> dimension, AABB boundingBox) {
        Iterator<Pair<AABB, Float>> itr = TickrateUtil.getTickrateAreas(dimension).iterator();
        if (itr.hasNext()) {
            Pair<AABB, Float> pair = itr.next();
            AABB aabb = (AABB)pair.getLeft();
            return Pair.of((Object)aabb.m_82381_(boundingBox), (Object)((Float)pair.getRight()));
        }
        return Pair.of((Object)false, (Object)Float.valueOf(20.0f));
    }

    public static <T extends Entity> T getEntityByUUID(Level level, UUID uuid) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return (T)((Entity)entities.m_142694_(uuid));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

