/*
 * Decompiled with CFR 0.152.
 */
package com.min01.tickrateapi.world;

import com.min01.tickrateapi.util.CustomTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class TickrateSavedData
extends SavedData {
    public static final String NAME = "tickrate_data";
    private CustomTimer currentTimer = new CustomTimer(20.0f, 0L);
    private final List<Pair<AABB, Float>> areas = new ArrayList<Pair<AABB, Float>>();

    public static TickrateSavedData get(ResourceKey<Level> dimension) {
        ServerLevel serverLevel;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (serverLevel = server.m_129880_(dimension)) != null) {
            DimensionDataStorage storage = serverLevel.m_8895_();
            TickrateSavedData data = (TickrateSavedData)storage.m_164861_(TickrateSavedData::load, TickrateSavedData::new, NAME);
            return data;
        }
        return null;
    }

    public static TickrateSavedData load(CompoundTag nbt) {
        TickrateSavedData data = new TickrateSavedData();
        data.currentTimer.setTickrate(nbt.m_128457_("DimensionTickrate"));
        ListTag areas = nbt.m_128437_("Areas", 10);
        for (int i = 0; i < areas.size(); ++i) {
            CompoundTag tag = areas.m_128728_(i);
            data.addTickrateArea(new AABB(tag.m_128459_("MinX"), tag.m_128459_("MinY"), tag.m_128459_("MinZ"), tag.m_128459_("MaxX"), tag.m_128459_("MaxY"), tag.m_128459_("MaxZ")), tag.m_128457_("AreaTickrate"));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag areas = new ListTag();
        this.areas.forEach(t -> {
            CompoundTag tag = new CompoundTag();
            AABB aabb = (AABB)t.getLeft();
            tag.m_128347_("MinX", aabb.f_82288_);
            tag.m_128347_("MinY", aabb.f_82289_);
            tag.m_128347_("MinZ", aabb.f_82290_);
            tag.m_128347_("MaxX", aabb.f_82291_);
            tag.m_128347_("MaxY", aabb.f_82292_);
            tag.m_128347_("MaxZ", aabb.f_82293_);
            tag.m_128350_("AreaTickrate", ((Float)t.getRight()).floatValue());
            areas.add((Object)tag);
        });
        nbt.m_128350_("DimensionTickrate", this.currentTimer.tickrate);
        nbt.m_128365_("Areas", (Tag)areas);
        return nbt;
    }

    public void setTickrate(float tickrate) {
        this.currentTimer.setTickrate(tickrate);
        this.m_77762_();
    }

    public CustomTimer getTimer() {
        return this.currentTimer;
    }

    public void addTickrateArea(AABB aabb, float tickrate) {
        if (tickrate == 20.0f) {
            Iterator<Pair<AABB, Float>> itr = this.areas.iterator();
            while (itr.hasNext()) {
                Pair<AABB, Float> next = itr.next();
                if (!((AABB)next.getLeft()).equals((Object)aabb)) continue;
                itr.remove();
            }
            this.m_77762_();
        } else {
            Pair pair = Pair.of((Object)aabb, (Object)Float.valueOf(tickrate));
            this.areas.add((Pair<AABB, Float>)pair);
            this.m_77762_();
        }
    }

    public List<Pair<AABB, Float>> getTickrateAreas() {
        return this.areas;
    }
}

