/*
 * Decompiled with CFR 0.152.
 */
package com.min01.villageandvillagers.entity.misc;

import com.min01.villageandvillagers.entity.AbstractOwnableEntity;
import com.min01.villageandvillagers.entity.IClipPos;
import com.min01.villageandvillagers.entity.villager.EntityHarvester;
import com.min01.villageandvillagers.misc.SmoothAnimationState;
import com.min01.villageandvillagers.util.VillageUtil;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class EntityHaybaleBarricade
extends AbstractOwnableEntity<EntityHarvester>
implements IClipPos {
    public static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EntityHaybaleBarricade.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ANIMATION_TICK = SynchedEntityData.m_135353_(EntityHaybaleBarricade.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DURABILITY = SynchedEntityData.m_135353_(EntityHaybaleBarricade.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final SmoothAnimationState appearAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState disappearAnimationState = new SmoothAnimationState();

    public EntityHaybaleBarricade(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(ANIMATION_TICK, (Object)0);
        this.f_19804_.m_135372_(DURABILITY, (Object)100);
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.appearAnimationState.updateWhen(this.getAnimationState() == 1, this.f_19797_);
            this.disappearAnimationState.updateWhen(this.getAnimationState() == 2, this.f_19797_);
        }
        if ((this.getDurability() <= 0 || this.f_19797_ >= 200) && this.getAnimationState() == 0) {
            this.setAnimationState(2);
            this.setAnimationTick(8);
        }
        if (this.getAnimationTick() > 0) {
            this.setAnimationTick(this.getAnimationTick() - 1);
        } else {
            if (this.getAnimationState() == 1) {
                this.setAnimationState(0);
            }
            if (this.getAnimationState() == 2) {
                this.m_146870_();
            }
        }
    }

    public void m_20334_(double p_20335_, double p_20336_, double p_20337_) {
    }

    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public boolean m_6469_(DamageSource p_19946_, float p_19947_) {
        if (this.getDurability() > 0) {
            int damage = p_19946_.m_269533_(DamageTypeTags.f_268745_) ? 2 : 1;
            this.m_216990_(SoundEvents.f_11988_);
            this.setDurability(this.getDurability() - damage);
            for (int i = 0; i < 20; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50335_.m_49966_()), this.m_20185_() + this.f_19796_.m_188583_() * (double)0.1f, this.m_20188_(), this.m_20189_() + this.f_19796_.m_188583_() * (double)0.1f, this.f_19796_.m_188583_() * (double)0.1f, this.f_19796_.m_188583_() * (double)0.1f, this.f_19796_.m_188583_() * (double)0.1f);
            }
        }
        return p_19946_.m_269533_(DamageTypeTags.f_268738_);
    }

    @Override
    public void m_7380_(CompoundTag p_37265_) {
        super.m_7380_(p_37265_);
        p_37265_.m_128405_("Durability", this.getDurability());
    }

    @Override
    public void m_7378_(CompoundTag p_37262_) {
        super.m_7378_(p_37262_);
        this.setDurability(p_37262_.m_128451_("Durability"));
    }

    @Override
    public Vec3 getClipPos(Vec3 from, Vec3 to, Entity entity) {
        Vec3 motion = VillageUtil.fromToVector(from, to, (float)from.m_82554_(this.m_146892_()) - 3.5f);
        Vec3 pos = from.m_82549_(motion);
        return pos;
    }

    public void setDurability(int value) {
        this.f_19804_.m_135381_(DURABILITY, (Object)value);
    }

    public int getDurability() {
        return (Integer)this.f_19804_.m_135370_(DURABILITY);
    }

    public void setAnimationTick(int value) {
        this.f_19804_.m_135381_(ANIMATION_TICK, (Object)value);
    }

    public int getAnimationTick() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_TICK);
    }

    public void setAnimationState(int value) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)value);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }
}

