/*
 * Decompiled with CFR 0.152.
 */
package com.min01.villageandvillagers.entity.model;

import com.min01.villageandvillagers.entity.animation.HarvesterAnimation;
import com.min01.villageandvillagers.entity.villager.EntityHarvester;
import com.min01.villageandvillagers.util.VillageClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelHarvester
extends HierarchicalModel<EntityHarvester> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("villageandvillagers", "harvester"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart upperbody;
    private final ModelPart head;
    private final ModelPart arms_out;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart arms_crossed;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public ModelHarvester(ModelPart root) {
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.upperbody = this.body.m_171324_("upperbody");
        this.head = this.upperbody.m_171324_("head");
        this.arms_out = this.upperbody.m_171324_("arms_out");
        this.left_arm = this.arms_out.m_171324_("left_arm");
        this.right_arm = this.arms_out.m_171324_("right_arm");
        this.arms_crossed = this.upperbody.m_171324_("arms_crossed");
        this.right_leg = this.body.m_171324_("right_leg");
        this.left_leg = this.body.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition upperbody = body.m_171599_("upperbody", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition head = upperbody.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(28, 40).m_171488_(-4.0f, -5.0f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(28, 24).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-4.0f));
        head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171488_(-8.0f, 0.25f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(0, 32).m_171488_(-4.0f, -4.75f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.25f, (float)0.0f));
        head.m_171599_("wheat", CubeListBuilder.m_171558_().m_171514_(14, 22).m_171488_(-1.0f, 0.0f, -6.0f, 2.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-1.0f, (float)-4.0f, (float)0.3927f, (float)0.7854f, (float)0.0f));
        PartDefinition arms_out = upperbody.m_171599_("arms_out", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        arms_out.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-22.0f, (float)0.0f));
        PartDefinition right_arm = arms_out.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-22.0f, (float)0.0f));
        PartDefinition pitchfork = right_arm.m_171599_("pitchfork", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)8.5f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        pitchfork.m_171599_("fork_locator", CubeListBuilder.m_171558_().m_171514_(67, 2).m_171488_(-0.5f, 3.5f, -0.5f, 1.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(71, 4).m_171488_(-0.5f, -3.5f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(75, 4).m_171488_(-3.5f, -3.5f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(71, 11).m_171488_(2.5f, -3.5f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(71, 2).m_171488_(-3.5f, 2.5f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.0f, (float)0.0f));
        upperbody.m_171599_("arms_crossed", CubeListBuilder.m_171558_().m_171514_(48, 20).m_171488_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(34, 28).m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(28, 16).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        upperbody.m_171599_("satchel", CubeListBuilder.m_171558_().m_171514_(29, 55).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-1.0f, (float)-2.0f));
        body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(52, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityHarvester entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        VillageClientUtil.animateHead(this.head, netHeadYaw, headPitch);
        entity.stabAnimationState.animate(this, HarvesterAnimation.HARVESTER_STAB, ageInTicks);
        entity.twoHandStabAnimationState.animate(this, HarvesterAnimation.HARVESTER_TWO_HAND_STAB, ageInTicks);
        entity.stompAnimationState.animate(this, HarvesterAnimation.HARVESTER_STOMP, ageInTicks);
        this.arms_crossed.f_104207_ = !entity.isCombatMode();
        this.arms_out.f_104207_ = entity.isCombatMode();
        if (entity.getAnimationState() != 0) {
            limbSwing = 0.0f;
            limbSwingAmount = 0.0f;
        }
        this.right_leg.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.left_leg.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.right_arm.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.left_arm.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

