/*
 * Decompiled with CFR 0.152.
 */
package com.min01.villageandvillagers.entity.model;

import com.min01.villageandvillagers.entity.villager.EntityRobinHood;
import com.min01.villageandvillagers.util.VillageClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelRobinHood
extends HierarchicalModel<EntityRobinHood> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("villageandvillagers", "robin_hood"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart arms;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public ModelRobinHood(ModelPart root) {
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.arms = this.body.m_171324_("arms");
        this.right_arm = this.body.m_171324_("right_arm");
        this.left_arm = this.body.m_171324_("left_arm");
        this.right_leg = this.body.m_171324_("right_leg");
        this.left_leg = this.body.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(82, 22).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(32, -15).m_171488_(-3.3f, -3.0f, -4.5f, 0.0f, 16.0f, 16.0f, new CubeDeformation(-3.0f)), PartPose.m_171423_((float)4.0f, (float)-18.0f, (float)4.0f, (float)2.7053f, (float)0.0f, (float)3.1416f));
        PartDefinition beard = head.m_171599_("beard", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-2.3612f, (float)-4.1f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        beard.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(80, 76).m_171480_().m_171488_(-7.2f, -3.5f, 0.0f, 8.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.5f, (float)0.1612f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        beard.m_171599_("head_r3", CubeListBuilder.m_171558_().m_171514_(80, 76).m_171488_(-0.8f, -3.5f, 0.0f, 8.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)0.1612f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition headwear = head.m_171599_("headwear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        headwear.m_171599_("headwear_r1", CubeListBuilder.m_171558_().m_171514_(60, 9).m_171488_(-4.0f, -1.1f, -4.8f, 8.0f, 2.0f, 11.0f, new CubeDeformation(0.51f)), PartPose.m_171423_((float)0.0f, (float)-7.6f, (float)-1.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bodywear = body.m_171599_("bodywear", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)).m_171514_(32, 52).m_171488_(-4.5f, -0.6f, -3.5f, 9.0f, 5.0f, 7.0f, new CubeDeformation(0.2f)).m_171514_(33, 86).m_171488_(-4.5f, -0.6f, -3.5f, 9.0f, 14.0f, 7.0f, new CubeDeformation(0.4f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        bodywear.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(16, 80).m_171488_(-2.5f, -4.2f, -1.5f, 5.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(20, 72).m_171488_(-2.0f, -3.0f, -1.0f, 4.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4096f, (float)4.2868f, (float)4.5f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        bodywear.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(5, 88).m_171488_(-7.4f, -4.5f, 0.3f, 12.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.3074f, (float)0.6984f, (float)4.5f, (float)0.0f, (float)0.0f, (float)-2.6616f));
        bodywear.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(5, 88).m_171488_(-14.8f, -8.8f, -1.0f, 12.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-12.2074f, (float)-2.1016f, (float)5.5f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(40, 38).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 22).m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.05f, (float)-1.05f, (float)-0.7505f, (float)0.0f, (float)0.0f));
        arms.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(64, 64).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.3f)).m_171555_(false), PartPose.m_171423_((float)6.0f, (float)-0.95f, (float)0.05f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        arms.m_171599_("left_arm_r2", CubeListBuilder.m_171558_().m_171514_(64, 72).m_171480_().m_171488_(-2.0f, -2.0f, -3.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.3f)).m_171555_(false), PartPose.m_171423_((float)-6.0f, (float)-0.95f, (float)1.05f, (float)0.0f, (float)0.0f, (float)0.0873f));
        arms.m_171599_("mirrored", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171488_(4.0f, -23.05f, -3.05f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)21.05f, (float)1.05f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(32, 64).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-10.0f, (float)0.0f));
        right_arm.m_171599_("left_arm_r3", CubeListBuilder.m_171558_().m_171514_(64, 72).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.3f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(48, 64).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)-10.0f, (float)0.0f));
        left_arm.m_171599_("left_arm_r4", CubeListBuilder.m_171558_().m_171514_(64, 64).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.3f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 80).m_171488_(-2.0f, 5.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(32, 80).m_171480_().m_171488_(-2.0f, 5.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.3f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityRobinHood entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        VillageClientUtil.animateHead(this.head, netHeadYaw, headPitch);
        this.arms.f_104207_ = !entity.isCombatMode();
        this.right_arm.f_104207_ = entity.isCombatMode();
        this.left_arm.f_104207_ = entity.isCombatMode();
        if (entity.getAnimationState() != 0) {
            limbSwing = 0.0f;
            limbSwingAmount = 0.0f;
        }
        this.right_leg.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.left_leg.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.right_arm.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.left_arm.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

