/*
 * Decompiled with CFR 0.152.
 */
package com.min01.villageandvillagers.entity.model;

import com.min01.villageandvillagers.entity.villager.EntityTimeKeeper;
import com.min01.villageandvillagers.util.VillageClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelTimeKeeper
extends HierarchicalModel<EntityTimeKeeper> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("villageandvillagers", "time_keeper"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart uncrossed_arms;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart crossed_arms;

    public ModelTimeKeeper(ModelPart root) {
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.uncrossed_arms = this.body.m_171324_("uncrossed_arms");
        this.left_arm = this.uncrossed_arms.m_171324_("left_arm");
        this.right_arm = this.uncrossed_arms.m_171324_("right_arm");
        this.left_leg = this.body.m_171324_("left_leg");
        this.right_leg = this.body.m_171324_("right_leg");
        this.crossed_arms = this.body.m_171324_("crossed_arms");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(48, 0).m_171488_(-4.0f, -26.0f, -2.0f, 8.0f, 2.0f, 6.0f, new CubeDeformation(0.25f)).m_171514_(0, 14).m_171488_(-4.0f, -24.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(28, 14).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(1.0f, -4.0f, -4.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(48, 8).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(28, 32).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)).m_171514_(0, 0).m_171488_(-6.0f, -2.0f, -6.0f, 12.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        hat.m_171599_("pipe", CubeListBuilder.m_171558_().m_171514_(24, 64).m_171488_(0.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(34, 64).m_171488_(1.0f, -3.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(42, 64).m_171488_(1.0f, -3.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)4.0f, (float)-6.0f, (float)0.0f));
        hat.m_171599_("hour_hand", CubeListBuilder.m_171558_().m_171514_(58, 10).m_171488_(-0.5f, -2.5f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        hat.m_171599_("minute_hand", CubeListBuilder.m_171558_().m_171514_(56, 10).m_171488_(-0.5f, -3.5f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-4.5f));
        PartDefinition uncrossed_arms = body.m_171599_("uncrossed_arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        uncrossed_arms.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(50, 64).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(66, 64).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)4.0f, (float)-22.0f, (float)0.0f));
        uncrossed_arms.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 66).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(16, 68).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)-4.0f, (float)-22.0f, (float)0.0f));
        body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(28, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(44, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        body.m_171599_("crossed_arms", CubeListBuilder.m_171558_().m_171514_(60, 16).m_171488_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 58).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(60, 28).m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(60, 40).m_171488_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(60, 52).m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(60, 8).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-21.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityTimeKeeper entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        VillageClientUtil.animateHead(this.head, netHeadYaw, headPitch);
        this.crossed_arms.f_104207_ = !entity.isCombatMode();
        this.uncrossed_arms.f_104207_ = entity.isCombatMode();
        if (entity.getAnimationState() != 0) {
            limbSwing = 0.0f;
            limbSwingAmount = 0.0f;
        }
        this.right_leg.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.left_leg.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.right_arm.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.left_arm.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

