/*
 * Decompiled with CFR 0.152.
 */
package com.min01.villageandvillagers.entity.projectile;

import com.min01.villageandvillagers.entity.VillageEntities;
import com.min01.villageandvillagers.item.VillageItems;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntitySpecialArrow
extends AbstractArrow {
    public static final EntityDataAccessor<Integer> ARROW_TYPE = SynchedEntityData.m_135353_(EntitySpecialArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int currentAmount;

    public EntitySpecialArrow(EntityType<? extends AbstractArrow> p_36721_, Level p_36722_) {
        super(p_36721_, p_36722_);
    }

    public EntitySpecialArrow(EntityType<? extends AbstractArrow> p_36711_, double p_36712_, double p_36713_, double p_36714_, Level p_36715_) {
        this(p_36711_, p_36715_);
        this.m_6034_(p_36712_, p_36713_, p_36714_);
    }

    public EntitySpecialArrow(EntityType<? extends AbstractArrow> p_36717_, LivingEntity p_36718_, Level p_36719_) {
        this(p_36717_, p_36718_.m_20185_(), p_36718_.m_20188_() - (double)0.1f, p_36718_.m_20189_(), p_36719_);
        this.m_5602_((Entity)p_36718_);
        if (p_36718_ instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ARROW_TYPE, (Object)0);
    }

    protected void m_5790_(EntityHitResult p_36757_) {
        if (this.getArrowType() == SpecialArrowType.ENDER && this.m_19749_() != null) {
            Vec3 pos = p_36757_.m_82450_();
            Vec3 originalPos = this.m_19749_().m_20182_();
            this.m_19749_().m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            p_36757_.m_82443_().m_6021_(originalPos.f_82479_, originalPos.f_82480_, originalPos.f_82481_);
        }
        super.m_5790_(p_36757_);
    }

    protected void m_6532_(HitResult p_37260_) {
        if (this.currentAmount < this.getArrowType().maxAmount) {
            if (this.getArrowType() == SpecialArrowType.MULTI) {
                for (int i = 0; i < 5; ++i) {
                    EntitySpecialArrow arrow = new EntitySpecialArrow((EntityType<? extends AbstractArrow>)((EntityType)VillageEntities.SPECIAL_ARROW.get()), this.f_19853_);
                    CompoundTag tag = this.m_20240_(new CompoundTag());
                    arrow.m_20258_(tag);
                    arrow.m_20084_(UUID.randomUUID());
                    arrow.m_146884_(this.m_20182_().m_82520_(0.0, 0.5, 0.0));
                    arrow.m_20334_(this.f_19853_.f_46441_.m_188583_() * 0.2, 0.4, this.f_19853_.f_46441_.m_188583_() * 0.2);
                    arrow.currentAmount = this.currentAmount + 1;
                    this.f_19853_.m_7967_((Entity)arrow);
                }
            }
            ++this.currentAmount;
        }
        super.m_6532_(p_37260_);
    }

    protected void m_8060_(BlockHitResult p_36755_) {
        if (this.currentAmount < this.getArrowType().maxAmount) {
            BlockPos pos;
            BlockState state;
            if (this.getArrowType() == SpecialArrowType.BOUNCY) {
                double x = this.m_20184_().f_82479_;
                double y = this.m_20184_().f_82480_;
                double z = this.m_20184_().f_82481_;
                Direction direction = p_36755_.m_82434_();
                if (direction == Direction.EAST) {
                    x = -x;
                } else if (direction == Direction.SOUTH) {
                    z = -z;
                } else if (direction == Direction.WEST) {
                    x = -x;
                } else if (direction == Direction.NORTH) {
                    z = -z;
                } else if (direction == Direction.UP) {
                    y = -y;
                } else if (direction == Direction.DOWN) {
                    y = -y;
                }
                this.m_20334_(x, y, z);
            }
            if (this.getArrowType() == SpecialArrowType.PIERCING && !(state = this.f_19853_.m_8055_(pos = p_36755_.m_82425_())).m_204336_(BlockTags.f_13069_) && !state.m_204336_(BlockTags.f_13070_)) {
                this.f_19853_.m_46953_(pos, true, (Entity)this);
            }
            ++this.currentAmount;
        } else {
            super.m_8060_(p_36755_);
        }
    }

    protected ItemStack m_7941_() {
        return this.getArrowType().getStack().get();
    }

    public void m_7380_(CompoundTag p_36772_) {
        super.m_7380_(p_36772_);
        p_36772_.m_128405_("ArrowType", this.getArrowType().ordinal());
        p_36772_.m_128405_("CurrentAmount", this.currentAmount);
    }

    public void m_7378_(CompoundTag p_36761_) {
        super.m_7378_(p_36761_);
        this.setArrowType(SpecialArrowType.values()[p_36761_.m_128451_("ArrowType")]);
        this.currentAmount = p_36761_.m_128451_("CurrentAmount");
    }

    protected Component m_5677_() {
        return Component.m_237115_((String)("entity.villageandvillagers." + this.getArrowType().name));
    }

    public void setArrowType(SpecialArrowType type) {
        this.f_19804_.m_135381_(ARROW_TYPE, (Object)type.ordinal());
    }

    public byte m_36796_() {
        if (this.getArrowType() == SpecialArrowType.PIERCING) {
            return (byte)this.getArrowType().maxAmount;
        }
        return super.m_36796_();
    }

    public SpecialArrowType getArrowType() {
        return SpecialArrowType.values()[(Integer)this.f_19804_.m_135370_(ARROW_TYPE)];
    }

    public static enum SpecialArrowType {
        BOUNCY("bouncy_arrow", () -> ((Item)VillageItems.BOUNCY_ARROW.get()).m_7968_(), 5, true),
        ENDER("ender_arrow", () -> ((Item)VillageItems.ENDER_ARROW.get()).m_7968_(), 0, false),
        MULTI("multi_arrow", () -> ((Item)VillageItems.MULTI_ARROW.get()).m_7968_(), 3, false),
        PIERCING("piercing_arrow", () -> ((Item)VillageItems.PIERCING_ARROW.get()).m_7968_(), 5, true);

        private final String name;
        private final Supplier<ItemStack> stack;
        private final int maxAmount;
        private final boolean isInfinity;

        private SpecialArrowType(String name, Supplier<ItemStack> stack, int maxAmount, boolean isInfinity) {
            this.name = name;
            this.stack = stack;
            this.maxAmount = maxAmount;
            this.isInfinity = isInfinity;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }

        public Supplier<ItemStack> getStack() {
            return this.stack;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInfinity() {
            return this.isInfinity;
        }
    }
}

