/*
 * Decompiled with CFR 0.152.
 */
package com.min01.villageandvillagers.entity.projectile;

import com.min01.villageandvillagers.entity.EntityCameraShake;
import com.min01.villageandvillagers.util.VillageUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class EntityTimeGear
extends ThrowableProjectile {
    public static final EntityDataAccessor<Integer> GEAR_TYPE = SynchedEntityData.m_135353_(EntityTimeGear.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LIFE_TIME = SynchedEntityData.m_135353_(EntityTimeGear.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityTimeGear(EntityType<? extends ThrowableProjectile> p_37466_, Level p_37467_) {
        super(p_37466_, p_37467_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(GEAR_TYPE, (Object)0);
        this.f_19804_.m_135372_(LIFE_TIME, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
        if (this.m_19749_() == null) {
            this.m_146870_();
        } else {
            Mob owner = (Mob)this.m_19749_();
            if (this.getGearType() == GearType.TRACKING && owner.m_5448_() != null && this.f_19797_ >= 40 && this.f_19797_ <= 120) {
                this.m_20256_(VillageUtil.fromToVector(this.m_20182_(), owner.m_5448_().m_146892_(), 0.5f));
            }
        }
        if (this.f_19797_ >= this.getLifeTime()) {
            this.m_146870_();
        }
    }

    public EntityDimensions m_6972_(Pose p_19975_) {
        return this.getGearType().isLarge() ? EntityDimensions.m_20395_((float)3.0f, (float)3.0f) : super.m_6972_(p_19975_);
    }

    protected void m_8060_(BlockHitResult p_37258_) {
        super.m_8060_(p_37258_);
        if (this.getGearType() == GearType.FALLING && !this.m_20096_()) {
            EntityCameraShake.cameraShake(this.f_19853_, this.m_20182_(), 20.0f, 0.15f, 0, 10);
            for (int i = 0; i < 360; ++i) {
                Vec3 lookPos = VillageUtil.getLookPos(new Vec2(0.0f, (float)i), p_37258_.m_82450_(), 0.0, 0.5, 3.5);
                Vec3 lookPos2 = VillageUtil.getLookPos(new Vec2(0.0f, (float)i), p_37258_.m_82450_(), 0.0, 0.5, 10.0);
                Vec3 motion = VillageUtil.fromToVector(lookPos, lookPos2, 1.5f);
                this.f_19853_.m_7107_((ParticleOptions)ParticleTypes.f_123796_, lookPos.f_82479_, lookPos.f_82480_, lookPos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
            if (this.m_19749_() != null) {
                List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(1.5), t -> t != this.m_19749_() && !t.m_7307_(this.m_19749_()));
                list.forEach(t -> t.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)this.m_19749_()), 15.0f));
            }
            this.m_20256_(Vec3.f_82478_);
            this.setLifeTime(this.f_19797_ + 60);
            this.m_6853_(true);
        }
        if (this.getGearType() == GearType.TRACKING) {
            this.m_146870_();
        }
        if (this.getGearType() == GearType.EXPLOSIVE) {
            this.m_216990_(SoundEvents.f_11913_);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult p_37259_) {
        Entity entity;
        if (this.getGearType() == GearType.TRACKING && this.m_19749_() != null && (entity = p_37259_.m_82443_()) != this.m_19749_() && !entity.m_7307_(this.m_19749_())) {
            entity.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)this.m_19749_()), 5.0f);
            this.m_146870_();
        }
    }

    public Entity m_19749_() {
        UUID ownerUUID = (UUID)ObfuscationReflectionHelper.getPrivateValue(Projectile.class, (Object)((Object)this), (String)"f_37244_");
        if (ownerUUID != null) {
            return VillageUtil.getEntityByUUID(this.f_19853_, ownerUUID);
        }
        return super.m_19749_();
    }

    protected void m_7380_(CompoundTag p_37265_) {
        super.m_7380_(p_37265_);
        p_37265_.m_128405_("GearType", ((Integer)this.f_19804_.m_135370_(GEAR_TYPE)).intValue());
        p_37265_.m_128405_("LifeTime", this.getLifeTime());
    }

    protected void m_7378_(CompoundTag p_37262_) {
        super.m_7378_(p_37262_);
        if (p_37262_.m_128441_("GearType")) {
            this.setGearType(GearType.values()[p_37262_.m_128451_("GearType")]);
        }
        if (p_37262_.m_128441_("LifeTime")) {
            this.setLifeTime(p_37262_.m_128451_("LifeTime"));
        }
    }

    public void setLifeTime(int value) {
        this.f_19804_.m_135381_(LIFE_TIME, (Object)value);
    }

    public int getLifeTime() {
        return (Integer)this.f_19804_.m_135370_(LIFE_TIME);
    }

    public void setGearType(GearType type) {
        this.f_19804_.m_135381_(GEAR_TYPE, (Object)type.ordinal());
    }

    public GearType getGearType() {
        return GearType.values()[(Integer)this.f_19804_.m_135370_(GEAR_TYPE)];
    }

    public static enum GearType {
        TRACKING(false),
        FALLING(true),
        EXPLOSIVE(false);

        private boolean isLarge;

        private GearType(boolean isLarge) {
            this.isLarge = isLarge;
        }

        public boolean isLarge() {
            return this.isLarge;
        }
    }
}

