/*
 * Decompiled with CFR 0.152.
 */
package com.min01.villageandvillagers.event;

import com.min01.tickrateapi.util.TickrateUtil;
import com.min01.villageandvillagers.config.VillageConfig;
import com.min01.villageandvillagers.entity.VillageEntities;
import com.min01.villageandvillagers.entity.villager.AbstractCombatVillager;
import com.min01.villageandvillagers.item.VillageItems;
import com.min01.villageandvillagers.util.VillageUtil;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import tallestegg.guardvillagers.entities.Guard;

@Mod.EventBusSubscriber(modid="villageandvillagers", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandlerForge {
    @SubscribeEvent
    public static void onFinalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (mob instanceof Villager) {
            ServerLevel serverLevel;
            Level level;
            Villager villager = (Villager)mob;
            if (event.getSpawnType() == MobSpawnType.STRUCTURE && (level = villager.f_19853_) instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_215010_().m_220491_(villager.m_20183_(), StructureTags.f_215889_).m_73603_()) {
                List<EntityType> list = List.of((EntityType)VillageEntities.HARVESTER.get(), (EntityType)VillageEntities.ROBIN_HOOD.get());
                EntityType entityType = (EntityType)Util.m_214621_(list, (RandomSource)serverLevel.m_213780_());
                VillageUtil.convertVillagerToSpecial(entityType, villager, event);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        if (((Boolean)VillageConfig.disableDamageVillagers.get()).booleanValue()) {
            LivingEntity entity = event.getEntity();
            Entity source = event.getSource().m_7640_();
            if (source != null) {
                boolean flag;
                boolean bl = flag = ModList.get().isLoaded("guardvillagers") ? source instanceof Guard : false;
                if ((source instanceof IronGolem || source instanceof AbstractCombatVillager || flag) && (entity instanceof IronGolem || entity instanceof AbstractCombatVillager || flag || entity instanceof AbstractVillager)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity target;
        LivingEntity entity;
        if (((Boolean)VillageConfig.disableDamageVillagers.get()).booleanValue() && ((entity = event.getEntity()) instanceof IronGolem || entity instanceof AbstractCombatVillager || entity instanceof Guard) && ((target = event.getNewTarget()) instanceof IronGolem || target instanceof AbstractCombatVillager || target instanceof Guard || target instanceof AbstractVillager)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Iterable<Entity> all = VillageUtil.getAllEntities(event.level);
        for (Entity entity : all) {
            if (!(entity instanceof LivingEntity) || !entity.getPersistentData().m_128441_("ForceTickCount")) continue;
            int time = entity.getPersistentData().m_128451_("ForceTickCount");
            entity.getPersistentData().m_128405_("ForceTickCount", time - 1);
            TickrateUtil.setTickrate((Entity)entity, (float)entity.getPersistentData().m_128451_("TickrateVV"));
            if (time > 0) continue;
            entity.getPersistentData().m_128473_("ForceTickCount");
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        VillageUtil.getCurio(living, (Item)VillageItems.POCKET_WATCH.get(), t -> {
            Player player;
            if (living instanceof Player && !(player = (Player)living).m_36335_().m_41519_(t.m_41720_()) && living.m_21223_() <= 4.0f) {
                Entity entity = event.getSource().m_7639_();
                if (entity != null) {
                    VillageUtil.setTickrateWithTime(entity, 0, 60);
                    player.m_36335_().m_41524_(t.m_41720_(), 1200);
                } else {
                    List list = living.f_19853_.m_6443_(LivingEntity.class, living.m_20191_().m_82400_(5.0), target -> target != living && !living.m_7307_((Entity)target));
                    list.forEach(target -> VillageUtil.setTickrateWithTime((Entity)target, 0, 100));
                    player.m_36335_().m_41524_(t.m_41720_(), 1800);
                }
            }
        });
    }

    public static class EmeraldForItems
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int cost;
        private final int maxUses;
        private final int villagerXp;
        private final int emeraldCount;
        private final float priceMultiplier;

        public EmeraldForItems(ItemLike p_35657_, int p_35658_, int p_35659_, int p_35660_, int emeraldCount) {
            this.item = p_35657_.m_5456_();
            this.cost = p_35658_;
            this.maxUses = p_35659_;
            this.villagerXp = p_35660_;
            this.emeraldCount = emeraldCount;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity p_219682_, RandomSource p_219683_) {
            ItemStack itemstack = new ItemStack((ItemLike)this.item, this.cost);
            return new MerchantOffer(itemstack, new ItemStack((ItemLike)Items.f_42616_, this.emeraldCount), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

