/*
 * Decompiled with CFR 0.152.
 */
package com.min01.villageandvillagers.util;

import com.min01.villageandvillagers.entity.ITrail;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;

public class VillageClientUtil {
    public static final Minecraft MC = Minecraft.m_91087_();

    public static Vec3 getWorldPositionOfMultiPart(Entity entity, ModelPart root, Vec3 rotation, String ... modelPartName) {
        return VillageClientUtil.getWorldPosition(entity, root, false, rotation, modelPartName);
    }

    public static Vec3 getWorldPosition(Entity entity, ModelPart root, Vec3 rotation, String ... modelPartName) {
        return VillageClientUtil.getWorldPosition(entity, root, true, rotation, modelPartName);
    }

    public static Vec3 getWorldPosition(Entity entity, ModelPart root, boolean translateToEntity, Vec3 rotation, String ... modelPartName) {
        PoseStack poseStack = new PoseStack();
        if (translateToEntity) {
            float partialTick = MC.m_91296_();
            double x = Mth.m_14139_((double)partialTick, (double)entity.f_19790_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)partialTick, (double)entity.f_19791_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)partialTick, (double)entity.f_19792_, (double)entity.m_20189_());
            poseStack.m_85837_(x, y, z);
        }
        poseStack.m_252781_(new Quaternionf().rotateXYZ((float)Math.toRadians(rotation.f_82479_), (float)Math.toRadians(-rotation.f_82480_ + 180.0), (float)Math.toRadians(rotation.f_82481_)));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        ModelPart nextPart = null;
        for (int i = 0; i < modelPartName.length; ++i) {
            if (i == 0) {
                nextPart = root.m_171324_(modelPartName[0]);
                nextPart.m_104299_(poseStack);
                continue;
            }
            ModelPart child = nextPart.m_171324_(modelPartName[i]);
            child.m_104299_(poseStack);
            nextPart = child;
        }
        PoseStack.Pose last = poseStack.m_85850_();
        Matrix4f matrix4f = last.m_252922_();
        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vector4f.mul((Matrix4fc)matrix4f);
        return new Vec3((double)vector4f.x(), (double)vector4f.y(), (double)vector4f.z());
    }

    public static void drawBox(AABB boundingBox, PoseStack stack, MultiBufferSource bufferIn, Vec3 rgb, int alpha) {
        VillageClientUtil.drawBox(boundingBox, stack, bufferIn, rgb, 240, alpha, RenderType.m_110458_((ResourceLocation)new ResourceLocation("textures/block/ice.png")));
    }

    public static void drawBox(AABB boundingBox, PoseStack stack, MultiBufferSource bufferIn, Vec3 rgb, int light, int alpha, RenderType renderType) {
        VertexConsumer vertexbuffer = bufferIn.m_6299_(renderType);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float maxX = (float)boundingBox.f_82291_ * 0.425f;
        float minX = (float)boundingBox.f_82288_ * 0.425f;
        float maxY = (float)boundingBox.f_82292_ * 0.425f;
        float minY = (float)boundingBox.f_82289_ * 0.425f;
        float maxZ = (float)boundingBox.f_82293_ * 0.425f;
        float minZ = (float)boundingBox.f_82290_ * 0.425f;
        float maxU = maxZ - minZ;
        float maxV = maxY - minY;
        float minU = minZ - maxZ;
        float minV = minY - maxY;
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82289_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82292_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82292_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82289_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82289_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82292_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82292_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82289_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        maxU = maxX - minX;
        maxV = maxY - minY;
        minU = minX - maxX;
        minV = minY - maxY;
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82289_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82292_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82292_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82289_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82289_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82292_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82292_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82289_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        maxU = maxZ - minZ;
        maxV = maxX - minX;
        minU = minZ - maxZ;
        minV = minX - maxX;
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82292_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82292_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82292_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82292_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82289_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82288_, (float)boundingBox.f_82289_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82289_, (float)boundingBox.f_82290_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexbuffer.m_252986_(matrix4f, (float)boundingBox.f_82291_, (float)boundingBox.f_82289_, (float)boundingBox.f_82293_).m_85950_((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_, (float)alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
    }

    public static void renderTrail(ITrail entityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, float trailR, float trailG, float trailB, float trailA, int sampleSize, float trailHeight) {
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3(0.0, (double)trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 bottomAngleVec = new Vec3(0.0, (double)(-trailHeight), 0.0).m_82535_(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)new ResourceLocation("villageandvillagers", "textures/effect/trail.png")));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples, partialTicks);
            float u1 = (float)samples / (float)sampleSize;
            float u2 = u1 + 1.0f / (float)sampleSize;
            Vec3 draw1 = drawFrom;
            Vec3 draw2 = sample;
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw1.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw1.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw2.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw2.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw2.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw2.f_82479_ + (float)topAngleVec.f_82479_, (float)draw2.f_82480_ + (float)topAngleVec.f_82480_, (float)draw2.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)topAngleVec.f_82479_, (float)draw1.f_82480_ + (float)topAngleVec.f_82480_, (float)draw1.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            drawFrom = sample;
        }
    }

    public static void animateHead(ModelPart head, float netHeadYaw, float headPitch) {
        head.f_104204_ = (float)((double)head.f_104204_ + Math.toRadians(netHeadYaw));
        head.f_104203_ = (float)((double)head.f_104203_ + Math.toRadians(headPitch));
    }
}

