/*
 * Decompiled with CFR 0.152.
 */
package com.min01.villageandvillagers.util;

import com.min01.villageandvillagers.config.VillageConfig;
import com.min01.villageandvillagers.entity.villager.AbstractCombatVillager;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.joml.Math;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class VillageUtil {
    public static final Method GET_ENTITY = ObfuscationReflectionHelper.findMethod(Level.class, (String)"m_142646_", (Class[])new Class[0]);

    public static <T extends AbstractCombatVillager> void convertVillagerToSpecial(EntityType<T> entityType, Villager original, MobSpawnEvent.FinalizeSpawn event) {
        if (Math.random() <= (double)(((Float)VillageConfig.specialVillagerChance.get()).floatValue() / 100.0f)) {
            AbstractCombatVillager entity = (AbstractCombatVillager)entityType.m_20615_(original.f_19853_);
            entity.m_146884_(Vec3.m_82539_((Vec3i)original.m_20183_()));
            original.f_19853_.m_7967_((Entity)entity);
            event.setSpawnCancelled(true);
            event.setCanceled(true);
        }
    }

    public static void setTickrateWithTime(Entity entity, int tickrate, int time) {
        entity.getPersistentData().m_128405_("ForceTickCount", time);
        entity.getPersistentData().m_128405_("TickrateVV", tickrate);
    }

    public static void getCurio(LivingEntity living, Item item, Consumer<ItemStack> consumer) {
        CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(t -> {
            Optional slot = t.findFirstCurio(item);
            if (!slot.isEmpty()) {
                consumer.accept(((SlotResult)slot.get()).stack());
            }
        });
    }

    public static Vec3 getSpreadPosition(Level level, Vec3 startPos, double range) {
        double x = startPos.f_82479_ + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * range + 0.5;
        double y = startPos.f_82480_ + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * range + 0.5;
        double z = startPos.f_82481_ + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * range + 0.5;
        return new Vec3(x, y, z);
    }

    public static Vec3 getSpreadPosition(Entity entity, double range) {
        double x = entity.m_20185_() + (entity.f_19853_.f_46441_.m_188500_() - entity.f_19853_.f_46441_.m_188500_()) * range + 0.5;
        double y = entity.m_20186_() + (entity.f_19853_.f_46441_.m_188500_() - entity.f_19853_.f_46441_.m_188500_()) * range + 0.5;
        double z = entity.m_20189_() + (entity.f_19853_.f_46441_.m_188500_() - entity.f_19853_.f_46441_.m_188500_()) * range + 0.5;
        return new Vec3(x, y, z);
    }

    public static Vec3 getCirclePosition(Entity entity, double range) {
        double angle = entity.f_19853_.f_46441_.m_188500_() * java.lang.Math.PI * 2.0;
        double radius = Math.sqrt((double)entity.f_19853_.f_46441_.m_188500_()) * range;
        double x = entity.m_20185_() + Math.cos((double)angle) * radius;
        double y = entity.m_20186_();
        double z = entity.m_20189_() + Math.sin((double)angle) * radius;
        return new Vec3(x, y, z);
    }

    public static Vec3 getGroundPos(BlockGetter pLevel, double pX, double startY, double pZ) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(pX, startY, pZ);
        do {
            blockpos$mutable.m_122173_(Direction.DOWN);
        } while ((pLevel.m_8055_((BlockPos)blockpos$mutable).m_60795_() || pLevel.m_8055_((BlockPos)blockpos$mutable).m_278721_() || !pLevel.m_8055_((BlockPos)blockpos$mutable).m_60838_(pLevel, (BlockPos)blockpos$mutable)) && blockpos$mutable.m_123342_() > pLevel.m_141937_());
        BlockPos.MutableBlockPos blockpos = blockpos$mutable;
        return Vec3.m_82512_((Vec3i)blockpos);
    }

    public static void getClientLevel(Consumer<Level> consumer) {
        ((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).filter(ClientLevel.class::isInstance).ifPresent(level -> consumer.accept((Level)level));
    }

    public static Vec2 lookAt(Vec3 startPos, Vec3 pos) {
        Vec3 vec3 = startPos;
        double d0 = pos.f_82479_ - vec3.f_82479_;
        double d1 = pos.f_82480_ - vec3.f_82480_;
        double d2 = pos.f_82481_ - vec3.f_82481_;
        double d3 = Math.sqrt((double)(d0 * d0 + d2 * d2));
        float xRot = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
        float yRot = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        return new Vec2(xRot, yRot);
    }

    public static Vec3 fromToVector(Vec3 from, Vec3 to, float scale) {
        Vec3 motion = to.m_82546_(from).m_82541_();
        return motion.m_82490_((double)scale);
    }

    public static float distanceTo(Vec3 pos1, Vec3 pos2) {
        float f = (float)(pos1.f_82479_ - pos2.f_82479_);
        float f1 = (float)(pos1.f_82480_ - pos2.f_82480_);
        float f2 = (float)(pos1.f_82481_ - pos2.f_82481_);
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float distanceTo(Entity entity, Vec3 pos) {
        float f = (float)(entity.m_20185_() - pos.f_82479_);
        float f1 = (float)(entity.m_20186_() - pos.f_82480_);
        float f2 = (float)(entity.m_20189_() - pos.f_82481_);
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static Vec3 getLookPos(Vec2 rotation, Vec3 position, double left, double up, double forwards) {
        Vec2 vec2 = rotation;
        Vec3 vec3 = position;
        float f = Mth.m_14089_((float)((vec2.f_82471_ + 90.0f) * ((float)java.lang.Math.PI / 180)));
        float f1 = Mth.m_14031_((float)((vec2.f_82471_ + 90.0f) * ((float)java.lang.Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(-vec2.f_82470_ * ((float)java.lang.Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-vec2.f_82470_ * ((float)java.lang.Math.PI / 180)));
        float f4 = Mth.m_14089_((float)((-vec2.f_82470_ + 90.0f) * ((float)java.lang.Math.PI / 180)));
        float f5 = Mth.m_14031_((float)((-vec2.f_82470_ + 90.0f) * ((float)java.lang.Math.PI / 180)));
        Vec3 vec31 = new Vec3((double)(f * f2), (double)f3, (double)(f1 * f2));
        Vec3 vec32 = new Vec3((double)(f * f4), (double)f5, (double)(f1 * f4));
        Vec3 vec33 = vec31.m_82537_(vec32).m_82490_(-1.0);
        double d0 = vec31.f_82479_ * forwards + vec32.f_82479_ * up + vec33.f_82479_ * left;
        double d1 = vec31.f_82480_ * forwards + vec32.f_82480_ * up + vec33.f_82480_ * left;
        double d2 = vec31.f_82481_ * forwards + vec32.f_82481_ * up + vec33.f_82481_ * left;
        return new Vec3(vec3.f_82479_ + d0, vec3.f_82480_ + d1, vec3.f_82481_ + d2);
    }

    public static Iterable<Entity> getAllEntities(Level level) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return entities.m_142273_();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends Entity> T getEntityByUUID(Level level, UUID uuid) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return (T)((Entity)entities.m_142694_(uuid));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createLine(Level level, Vec3 targetPos, Vec3 pos, int maxDistance, BiConsumer<BlockPos, Integer> consumer) {
        double y = Math.min((double)targetPos.f_82480_, (double)pos.f_82480_);
        double yAbove = Math.max((double)targetPos.f_82480_, (double)pos.f_82480_) + 1.0;
        float f = (float)Mth.m_14136_((double)(targetPos.f_82481_ - pos.f_82481_), (double)(targetPos.f_82479_ - pos.f_82479_));
        for (int i = 0; i < maxDistance; ++i) {
            double d2 = 1.25 * (double)(i + 1);
            int delay = 1 * i;
            VillageUtil.createLine(level, pos.f_82479_ + (double)Mth.m_14089_((float)f) * d2, pos.f_82481_ + (double)Mth.m_14031_((float)f) * d2, y, yAbove, delay, consumer);
        }
    }

    public static void createLine(Level level, double x, double z, double y, double yAbove, int delay, BiConsumer<BlockPos, Integer> consumer) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)yAbove, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = level.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)level, blockpos1, Direction.UP)) continue;
            if (!level.m_46859_(blockpos) && !(voxelshape = (blockstate1 = level.m_8055_(blockpos)).m_60812_((BlockGetter)level, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)y) - 1);
        if (flag) {
            consumer.accept(BlockPos.m_274561_((double)x, (double)((double)blockpos.m_123342_() + d0), (double)z), delay);
        }
    }
}

