/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minepiece.entity.model;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.minepiece.entity.EntityGomuArmEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.loading.FMLPaths;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class EntityGomuArmModel
extends GeoModel<EntityGomuArmEntity> {
    private static final MinecraftSessionService sessionService = Minecraft.m_91087_().m_91108_();
    private final TextureManager textureManager = Minecraft.m_91087_().m_91097_();
    private final Map<UUID, ResourceLocation> skinCache = new HashMap<UUID, ResourceLocation>();

    public ResourceLocation getAnimationResource(EntityGomuArmEntity entity) {
        return new ResourceLocation("minepiece", "animations/entity_gomu_arm.animation.json");
    }

    public ResourceLocation getModelResource(EntityGomuArmEntity entity) {
        return new ResourceLocation("minepiece", "geo/entity_gomu_arm.geo.json");
    }

    public ResourceLocation getTextureResource(EntityGomuArmEntity entity) {
        Entity ownerEntity = this.getOwner(entity);
        if (ownerEntity instanceof Player) {
            Player playerOwner = (Player)ownerEntity;
            UUID ownerUUID = playerOwner.m_20148_();
            if (this.skinCache.containsKey(ownerUUID)) {
                return this.skinCache.get(ownerUUID);
            }
            ResourceLocation skin = this.getPlayerSkin(ownerUUID);
            this.skinCache.put(ownerUUID, skin);
            return skin;
        }
        return new ResourceLocation("minepiece", "textures/entities/" + entity.getTexture() + ".png");
    }

    private Entity getOwner(EntityGomuArmEntity entity) {
        LivingEntity owner;
        if (entity.m_21824_() && (owner = entity.m_269323_()) instanceof Player) {
            return owner;
        }
        return null;
    }

    private ResourceLocation getPlayerSkin(UUID uuid) {
        GameProfile profile = new GameProfile(uuid, null);
        Map textures = sessionService.getTextures(sessionService.fillProfileProperties(profile, false), false);
        if (textures.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            File skinFile;
            MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
            String skinUrl = profileTexture.getUrl();
            String skinHash = profileTexture.getHash();
            ResourceLocation resourceLocation = new ResourceLocation("skins/" + skinHash);
            File skinDir = new File(FMLPaths.GAMEDIR.get().toFile(), "cached_skins");
            if (!skinDir.exists()) {
                skinDir.mkdirs();
            }
            if (!(skinFile = new File(skinDir, skinHash + ".png")).exists()) {
                try {
                    this.downloadSkin(skinUrl, skinFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return DefaultPlayerSkin.m_118627_((UUID)uuid);
                }
            }
            HttpTexture httpTexture = new HttpTexture(skinFile, skinUrl, DefaultPlayerSkin.m_118627_((UUID)uuid), false, null);
            this.textureManager.m_118495_(resourceLocation, (AbstractTexture)httpTexture);
            return resourceLocation;
        }
        return DefaultPlayerSkin.m_118627_((UUID)uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadSkin(String skinUrl, File skinFile) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(skinUrl).openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            try (InputStream inputStream = connection.getInputStream();){
                Files.copy(inputStream, skinFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void setCustomAnimations(EntityGomuArmEntity animatable, long instanceId, AnimationState animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

