/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minepiece.procedures;

import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mcreator.minepiece.MinepieceMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(modid="minepiece", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SetupAnimationsProcedure {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(new ResourceLocation("minepiece", "player_animation"), 1000, SetupAnimationsProcedure::registerPlayerAnimations);
    }

    private static IAnimation registerPlayerAnimations(AbstractClientPlayer player) {
        return new ModifierLayer();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setAnimationClientside(Player player, String anim, boolean override) {
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer player_ = (AbstractClientPlayer)player;
            ModifierLayer animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player_).get(new ResourceLocation("minepiece", "player_animation"));
            if (animation == null) {
                return;
            }
            if (override || !animation.isActive()) {
                ResourceLocation animRL = new ResourceLocation("minepiece", anim);
                KeyframeAnimation retrievedAnimation = PlayerAnimationRegistry.getAnimation((ResourceLocation)animRL);
                if (retrievedAnimation == null) {
                    return;
                }
                animation.setAnimation((IAnimation)new KeyframeAnimationPlayer(retrievedAnimation));
            }
        }
    }

    public static void execute() {
        SetupAnimationsProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class MinepieceModAnimationMessage {
        String animation;
        int target;
        boolean override;

        public MinepieceModAnimationMessage(String animation, int target, boolean override) {
            this.animation = animation;
            this.target = target;
            this.override = override;
        }

        public MinepieceModAnimationMessage(FriendlyByteBuf buffer) {
            this.animation = buffer.m_130277_();
            this.target = buffer.readInt();
            this.override = buffer.readBoolean();
        }

        public static void buffer(MinepieceModAnimationMessage message, FriendlyByteBuf buffer) {
            buffer.m_130070_(message.animation);
            buffer.writeInt(message.target);
            buffer.writeBoolean(message.override);
        }

        public static void handler(MinepieceModAnimationMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                Level level;
                Player player;
                if (Minecraft.m_91087_().f_91074_ != null && (player = (Player)(level = Minecraft.m_91087_().f_91074_.m_9236_()).m_6815_(message.target)) != null && player instanceof AbstractClientPlayer) {
                    SetupAnimationsProcedure.setAnimationClientside(player, message.animation, message.override);
                }
            });
            context.setPacketHandled(true);
        }

        @SubscribeEvent
        public static void registerMessage(FMLCommonSetupEvent event) {
            MinepieceMod.addNetworkMessage(MinepieceModAnimationMessage.class, MinepieceModAnimationMessage::buffer, MinepieceModAnimationMessage::new, MinepieceModAnimationMessage::handler);
        }
    }
}

