/*
 * Decompiled with CFR 0.152.
 */
package com.cudzer.pumpkin_nightmares;

import com.cudzer.pumpkin_nightmares.PumpkinNightmaresMod;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="pumpkin_nightmares")
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue FERTILIZE_INTERVAL_TICKS = BUILDER.comment("Time in ticks between growth pulses from the Lifeblood Vessel (Default: 300 = 15 seconds)").defineInRange("fertilizeInterval", 300, 20, Integer.MAX_VALUE);
    private static final ModConfigSpec.IntValue FERTILIZE_RADIUS = BUILDER.comment("Radius around the Lifeblood Vessel for bonemeal effect (Default: 4 = 9x9x9 area)").defineInRange("fertilizeRadius", 4, 1, 16);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static int fertilizeInterval;
    public static int fertilizeRadius;

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            fertilizeInterval = (Integer)FERTILIZE_INTERVAL_TICKS.get();
            fertilizeRadius = (Integer)FERTILIZE_RADIUS.get();
            PumpkinNightmaresMod.LOGGER.info("Loaded Pumpkin Nightmares config settings.");
        }
    }

    @SubscribeEvent
    static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            PumpkinNightmaresMod.LOGGER.info("Reloading Pumpkin Nightmares config settings...");
            Config.onReload(event);
        }
    }
}

