/*
 * Decompiled with CFR 0.152.
 */
package com.cudzer.pumpkin_nightmares;

import com.cudzer.pumpkin_nightmares.Config;
import com.cudzer.pumpkin_nightmares.block.client.PumpkinHuskBlockRenderer;
import com.cudzer.pumpkin_nightmares.entity.PumpkingEntity;
import com.cudzer.pumpkin_nightmares.entity.PumpykinsEntity;
import com.cudzer.pumpkin_nightmares.entity.VinelingEntity;
import com.cudzer.pumpkin_nightmares.entity.client.PumpkingRenderer;
import com.cudzer.pumpkin_nightmares.entity.client.PumpykinsRenderer;
import com.cudzer.pumpkin_nightmares.entity.client.VinelingRenderer;
import com.cudzer.pumpkin_nightmares.gui.client.screen.CarvingScreen;
import com.cudzer.pumpkin_nightmares.item.PumpkinHuskBlockItem;
import com.cudzer.pumpkin_nightmares.item.PumpkinHuskBlockItemModel;
import com.cudzer.pumpkin_nightmares.particle.client.PumpkinParticle;
import com.cudzer.pumpkin_nightmares.particle.client.VineParticle;
import com.cudzer.pumpkin_nightmares.registry.PN_BlockEntities;
import com.cudzer.pumpkin_nightmares.registry.PN_Blocks;
import com.cudzer.pumpkin_nightmares.registry.PN_Entities;
import com.cudzer.pumpkin_nightmares.registry.PN_Items;
import com.cudzer.pumpkin_nightmares.registry.PN_MenuTypes;
import com.cudzer.pumpkin_nightmares.registry.PN_Particles;
import com.cudzer.pumpkin_nightmares.registry.PN_RecipeTypes;
import com.cudzer.pumpkin_nightmares.registry.PN_Sounds;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;

@Mod(value="pumpkin_nightmares")
public class PumpkinNightmaresMod {
    public static final String MODID = "pumpkin_nightmares";
    public static final Logger LOGGER = LogUtils.getLogger();

    public PumpkinNightmaresMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        PN_Entities.register(modEventBus);
        modEventBus.addListener(this::registerEntityAttributes);
        PN_Blocks.register(modEventBus);
        PN_Items.register(modEventBus);
        PN_Particles.register(modEventBus);
        PN_BlockEntities.register(modEventBus);
        PN_Sounds.register(modEventBus);
        PN_RecipeTypes.register(modEventBus);
        PN_MenuTypes.register(modEventBus);
        PN_Items.CREATIVE_MODE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(PN_Entities::onRegisterSpawns);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(PN_Entities.VINELING.get(), VinelingEntity.createAttributes().build());
        event.put(PN_Entities.PUMPKING.get(), PumpkingEntity.createAttributes().build());
        event.put(PN_Entities.PUMPYKINS.get(), PumpykinsEntity.createAttributes().build());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        BlockState state = level.getBlockState(pos);
        if (stack.is((Item)PN_Items.PUMPKING_HEART.get()) && state.is(Blocks.PUMPKIN)) {
            if (!level.isClientSide) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                PumpykinsEntity pumpykins = (PumpykinsEntity)PN_Entities.PUMPYKINS.get().create((Level)serverLevel);
                if (pumpykins != null) {
                    pumpykins.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, player.getYRot(), player.getXRot());
                    pumpykins.tame(player);
                    pumpykins.setPersistenceRequired();
                    pumpykins.finalizeSpawn((ServerLevelAccessor)serverLevel, level.getCurrentDifficultyAt(pos), MobSpawnType.EVENT, null);
                    serverLevel.addFreshEntity((Entity)pumpykins);
                    serverLevel.playSound(null, pos, SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 20, 0.5, 0.5, 0.5, 0.1);
                }
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @EventBusSubscriber(modid="pumpkin_nightmares", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(PN_Entities.VINELING.get(), VinelingRenderer::new);
            event.registerEntityRenderer(PN_Entities.PUMPKING.get(), PumpkingRenderer::new);
            event.registerEntityRenderer(PN_Entities.PUMPYKINS.get(), PumpykinsRenderer::new);
            event.registerBlockEntityRenderer(PN_BlockEntities.PUMPKIN_HUSK_BLOCK_ENTITY.get(), PumpkinHuskBlockRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerItem(new IClientItemExtensions(){
                private GeoItemRenderer<PumpkinHuskBlockItem> renderer;

                @NotNull
                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    if (this.renderer == null) {
                        this.renderer = new GeoItemRenderer((GeoModel)new PumpkinHuskBlockItemModel());
                    }
                    return this.renderer;
                }
            }, new Item[]{(Item)PN_Items.PUMPKIN_HUSK_BLOCK_ITEM.get()});
        }

        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)PN_Particles.PUMPKIN_PARTICLE.get(), PumpkinParticle.Provider::new);
            event.registerSpriteSet((ParticleType)PN_Particles.VINE_PARTICLE.get(), VineParticle.Provider::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)PN_MenuTypes.CARVING_MENU.get(), CarvingScreen::new);
        }
    }
}

