/*
 * Decompiled with CFR 0.152.
 */
package com.cudzer.pumpkin_nightmares.block.entity;

import com.cudzer.pumpkin_nightmares.Config;
import com.cudzer.pumpkin_nightmares.registry.PN_BlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LifebloodVesselBlockEntity
extends BlockEntity {
    private int tickCounter = 0;

    public LifebloodVesselBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)PN_BlockEntities.LIFEBLOOD_VESSEL_BLOCK_ENTITY.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, LifebloodVesselBlockEntity vessel) {
        vessel.tick(level, pos);
    }

    private void tick(Level level, BlockPos pos) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= Config.fertilizeInterval) {
            this.tickCounter = 0;
            this.applyBonemealEffect((ServerLevel)level, pos);
        }
    }

    private void applyBonemealEffect(ServerLevel serverLevel, BlockPos centerPos) {
        int radius = Config.fertilizeRadius;
        if (radius <= 0) {
            radius = 4;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BonemealableBlock bonemealable;
                    mutablePos.set(centerPos.getX() + x, centerPos.getY() + y, centerPos.getZ() + z);
                    BlockState targetState = serverLevel.getBlockState((BlockPos)mutablePos);
                    Block block = targetState.getBlock();
                    if (!(block instanceof BonemealableBlock) || !(bonemealable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)serverLevel, (BlockPos)mutablePos, targetState) || !bonemealable.isBonemealSuccess((Level)serverLevel, serverLevel.random, (BlockPos)mutablePos, targetState)) continue;
                    bonemealable.performBonemeal(serverLevel, serverLevel.random, (BlockPos)mutablePos, targetState);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)mutablePos.getX() + 0.5, (double)mutablePos.getY() + 0.5, (double)mutablePos.getZ() + 0.5, 3, 0.3, 0.3, 0.3, 0.0);
                }
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("TickCounter", this.tickCounter);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.tickCounter = tag.getInt("TickCounter");
    }
}

