/*
 * Decompiled with CFR 0.152.
 */
package com.cudzer.pumpkin_nightmares.block.entity;

import com.cudzer.pumpkin_nightmares.block.PumpkinHuskBlock;
import com.cudzer.pumpkin_nightmares.entity.PumpkingEntity;
import com.cudzer.pumpkin_nightmares.registry.PN_BlockEntities;
import com.cudzer.pumpkin_nightmares.registry.PN_Entities;
import com.cudzer.pumpkin_nightmares.registry.PN_Particles;
import com.cudzer.pumpkin_nightmares.registry.PN_Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpkinHuskBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int ritualTicks = 0;
    private static final int STAGE_CHARGE_UP_DURATION = 120;
    private static final int STAGE_COMET_TRAVEL_DURATION = 240;
    private static final int STAGE_ARRIVAL_DURATION = 60;
    private static final int RITUAL_TOTAL_DURATION = 420;
    private static final double RITUAL_DISTANCE = 14.0;
    private static final double SPIRAL_RADIUS = 1.0;
    private static final int SPIRAL_ROTATIONS = 10;
    private static final int COMET_TRAVEL_START_TICK = 300;
    private static final int ARRIVAL_START_TICK = 60;
    private boolean startSoundPlayed = false;
    private boolean endSoundPlayed = false;

    public PumpkinHuskBlockEntity(BlockPos pos, BlockState blockState) {
        super(PN_BlockEntities.PUMPKIN_HUSK_BLOCK_ENTITY.get(), pos, blockState);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController((GeoAnimatable)this, "pumpkin_husk_controller", 0, this::predicate));
    }

    public void startParticleEffect() {
        if (this.ritualTicks == 0) {
            this.ritualTicks = 420;
            this.setChanged();
        }
        if (this.level != null && !this.level.isClientSide) {
            this.level.playSound(null, this.worldPosition, (SoundEvent)PN_Sounds.EERIE_STEM_INSERT.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PumpkinHuskBlockEntity husk) {
        husk.tick();
    }

    private void tick() {
        if (this.ritualTicks <= 0) {
            return;
        }
        --this.ritualTicks;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction facing = (Direction)this.getBlockState().getValue((Property)PumpkinHuskBlock.FACING);
            Vec3 startPos = Vec3.atCenterOf((Vec3i)this.worldPosition);
            Vec3 finalPos = startPos.add((double)facing.getStepX() * 14.0, 0.0, (double)facing.getStepZ() * 14.0);
            if (this.ritualTicks >= 300) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.WITCH, startPos.x, startPos.y + 0.5, startPos.z, 5, 0.3, 0.3, 0.3, 0.01);
                if (this.ritualTicks % 10 == 0 && !this.startSoundPlayed) {
                    serverLevel.playSound(null, startPos.x, startPos.y, startPos.z, (SoundEvent)PN_Sounds.PUMPKING_SPAWN_START.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
                    this.startSoundPlayed = true;
                }
            } else if (this.ritualTicks >= 60) {
                double travelTicks = this.ritualTicks - 60;
                double progress = 1.0 - travelTicks / 240.0;
                double currentDistance = progress * 14.0;
                double yOffset = progress * (1.0 - progress) * 4.0 * 2.0;
                Vec3 currentPos = startPos.add((double)facing.getStepX() * currentDistance, yOffset, (double)facing.getStepZ() * currentDistance);
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)PN_Particles.PUMPKIN_PARTICLE.get()), currentPos.x, currentPos.y, currentPos.z, 3, 0.1, 0.1, 0.1, 0.0);
                serverLevel.playSound(null, finalPos.x, finalPos.y, finalPos.z, SoundEvents.WARDEN_HEARTBEAT, SoundSource.BLOCKS, 0.5f, 0.8f);
                Vec3 rightVec = Vec3.atLowerCornerOf((Vec3i)facing.getClockWise().getNormal());
                Vec3 upVec = new Vec3(0.0, 1.0, 0.0);
                double spiralAngle = progress * Math.PI * 2.0 * 10.0;
                Vec3 spiralOffset = rightVec.scale(Math.cos(spiralAngle) * 1.0).add(upVec.scale(Math.sin(spiralAngle) * 1.0));
                Vec3 spiralPos = currentPos.add(spiralOffset);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, spiralPos.x, spiralPos.y, spiralPos.z, 1, 0.0, 0.0, 0.0, 0.0);
            } else if (this.ritualTicks > 0) {
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)PN_Particles.VINE_PARTICLE.get()), finalPos.x, finalPos.y, finalPos.z, 15, 0.5, 0.5, 0.5, 0.05);
                if (this.ritualTicks % 10 == 0 && !this.endSoundPlayed) {
                    serverLevel.playSound(null, finalPos.x, finalPos.y, finalPos.z, (SoundEvent)PN_Sounds.PUMPKING_SUMMON_FINAL_PHASE.get(), SoundSource.BLOCKS, 0.5f, 0.8f);
                    this.endSoundPlayed = true;
                }
            } else {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, finalPos.x, finalPos.y, finalPos.z, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.playSound(null, finalPos.x, finalPos.y, finalPos.z, (SoundEvent)PN_Sounds.PUMPKING_SPAWN_END.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                PumpkingEntity pumpking = (PumpkingEntity)PN_Entities.PUMPKING.get().create((Level)serverLevel);
                if (pumpking != null) {
                    pumpking.moveTo(finalPos.x, finalPos.y - 0.5, finalPos.z, 0.0f, 0.0f);
                    pumpking.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(BlockPos.containing((Position)finalPos)), MobSpawnType.EVENT, null);
                    serverLevel.addFreshEntity((Entity)pumpking);
                    this.startSoundPlayed = false;
                    this.endSoundPlayed = false;
                }
            }
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.ritualTicks = 0;
    }

    private <E extends GeoBlockEntity> PlayState predicate(AnimationState<E> event) {
        event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.pumpkin_husk.idle"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

