/*
 * Decompiled with CFR 0.152.
 */
package com.cudzer.pumpkin_nightmares.entity;

import com.cudzer.pumpkin_nightmares.entity.VinelingEntity;
import com.cudzer.pumpkin_nightmares.registry.PN_Entities;
import com.cudzer.pumpkin_nightmares.registry.PN_Particles;
import com.cudzer.pumpkin_nightmares.registry.PN_Sounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpkingEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_ATTACK_TYPE = SynchedEntityData.defineId(PumpkingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ATTACK_TICK = SynchedEntityData.defineId(PumpkingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private AttackType currentAttack = AttackType.NONE;
    private int attackTick = 0;
    private boolean wasOnGround = true;
    private int attack1Cooldown = 500;
    private int attack2Cooldown = 250;
    private int attack3Cooldown = 200;
    private static final int ATTACK_1_INTERVAL = 500;
    private static final int ATTACK_2_INTERVAL = 250;
    private static final int ATTACK_3_INTERVAL = 200;
    private static final int ATTACK_2_UP_DURATION_TICKS = 30;
    private static final int ATTACK_2_SLAM_DURATION = 30;
    private static final int ATTACK_2_TOTAL_DURATION = 60;
    private static final int ATTACK_3_ANIMATION_DURATION = 30;
    private static final int ATTACK_3_PARTICLE_DELAY = 15;
    private static final int ATTACK_3_DAMAGE_DELAY = 10;
    private static final int ATTACK_3_TOTAL_DURATION = 55;
    @Nullable
    private BlockPos attack3TargetPos = null;
    @Nullable
    private UUID attack3TargetUUID = null;
    private final ServerBossEvent bossEvent = new ServerBossEvent(Objects.requireNonNull(this.getDisplayName()), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);

    public PumpkingEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.setNoAi(true);
        this.setPersistenceRequired();
        this.setNoGravity(true);
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)PN_Sounds.PUMPKING_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)PN_Sounds.PUMPKING_DEATH.get();
    }

    protected int getBaseExperienceReward() {
        return 72;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ATTACK_TYPE, (Object)AttackType.NONE.ordinal());
        builder.define(DATA_ATTACK_TICK, (Object)0);
    }

    public void startSeenByPlayer(@NotNull ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossEvent.removePlayer(player);
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossEvent.setName(Objects.requireNonNull(this.getDisplayName()));
    }

    public void tick() {
        super.tick();
        AttackType clientAttackType = AttackType.values()[(Integer)this.entityData.get(DATA_ATTACK_TYPE)];
        int clientAttackTick = (Integer)this.entityData.get(DATA_ATTACK_TICK);
        boolean currentOnGround = this.onGround();
        if (!this.level().isClientSide) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
            switch (this.currentAttack.ordinal()) {
                case 0: {
                    if (this.attack1Cooldown > 0) {
                        --this.attack1Cooldown;
                    }
                    if (this.attack2Cooldown > 0) {
                        --this.attack2Cooldown;
                    }
                    if (this.attack3Cooldown > 0) {
                        --this.attack3Cooldown;
                    }
                    if (this.attack3Cooldown <= 0) {
                        this.startAttack3(serverLevel);
                        break;
                    }
                    if (this.attack1Cooldown <= 0) {
                        this.performAttack1();
                        this.attack1Cooldown = 500 + this.random.nextInt(40) - 20;
                        break;
                    }
                    if (this.attack2Cooldown > 0) break;
                    this.startAttack2();
                    break;
                }
                case 1: {
                    this.handleSlamTick(serverLevel, currentOnGround);
                    break;
                }
                case 3: {
                    this.handleTargetedStrikeTick(serverLevel);
                }
            }
            this.wasOnGround = currentOnGround;
            this.handleLookAtPlayer();
        }
        if (clientAttackType == AttackType.SLAM && clientAttackTick > 0) {
            boolean applyGravity;
            Vec3 currentDelta = this.getDeltaMovement();
            double targetYDelta = currentDelta.y;
            int elapsedTicks = 60 - clientAttackTick;
            if (elapsedTicks < 30) {
                targetYDelta = 0.6;
            }
            boolean bl = applyGravity = !currentOnGround && elapsedTicks >= 30;
            if (applyGravity) {
                targetYDelta -= 0.25;
            } else if (currentOnGround && elapsedTicks > 1) {
                targetYDelta = 0.0;
            }
            targetYDelta = Mth.clamp((double)targetYDelta, (double)-2.0, (double)1.5);
            this.setDeltaMovement(0.0, targetYDelta, 0.0);
        } else if (!currentOnGround) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.25, 0.0));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
        }
    }

    private void startAttack3(ServerLevel serverLevel) {
        this.currentAttack = AttackType.TARGETED_STRIKE;
        this.attackTick = 55;
        this.entityData.set(DATA_ATTACK_TYPE, (Object)this.currentAttack.ordinal());
        this.entityData.set(DATA_ATTACK_TICK, (Object)this.attackTick);
        this.attack3Cooldown = 200 + this.random.nextInt(60) - 30;
        this.attack3TargetPos = null;
        this.attack3TargetUUID = null;
        serverLevel.playSound(null, this.blockPosition(), (SoundEvent)PN_Sounds.PUMPKING_ATTACK_STAB_DOWN.get(), SoundSource.HOSTILE, 1.0f, 0.7f);
    }

    private void startAttack2() {
        if (!this.level().isClientSide) {
            this.currentAttack = AttackType.SLAM;
            this.attackTick = 60;
            this.entityData.set(DATA_ATTACK_TYPE, (Object)this.currentAttack.ordinal());
            this.entityData.set(DATA_ATTACK_TICK, (Object)this.attackTick);
            this.attack2Cooldown = 250 + this.random.nextInt(60) - 30;
            this.wasOnGround = false;
            this.level().playSound(null, this.blockPosition(), (SoundEvent)PN_Sounds.PUMPKING_ATTACK_STOMP_JUMP.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    private void performAreaDamage() {
        if (!this.level().isClientSide) {
            float damageAmount = 15.0f;
            double radius = 5.0;
            AABB area = new AABB(this.getX() - radius, this.getY() - 12.0, this.getZ() - radius, this.getX() + radius, this.getY() + 2.0, this.getZ() + radius);
            List allPlayersInBox = this.level().getEntitiesOfClass(Player.class, area);
            ArrayList<Player> targets = new ArrayList<Player>();
            for (Player playerEntity : allPlayersInBox) {
                boolean bl;
                boolean alive = playerEntity.isAlive();
                boolean bl2 = bl = !playerEntity.isCreative() && !playerEntity.isSpectator();
                if (!alive || !bl) continue;
                targets.add(playerEntity);
            }
            ArrayList<Player> nearbyEntities = targets;
            this.level().playSound(null, this.blockPosition(), (SoundEvent)PN_Sounds.PUMPKING_ATTACK_STOMP_LANDING.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            DamageSource source = this.damageSources().mobAttack((LivingEntity)this);
            for (LivingEntity livingEntity : nearbyEntities) {
                double dz;
                boolean damaged = livingEntity.hurt(source, damageAmount);
                double dx = livingEntity.getX() - this.getX();
                double distance = Math.sqrt(dx * dx + (dz = livingEntity.getZ() - this.getZ()) * dz);
                if (!(distance > 0.0)) continue;
                livingEntity.knockback(1.0, -dx / distance, -dz / distance);
            }
        }
    }

    private void handleTargetedStrikeTick(ServerLevel serverLevel) {
        --this.attackTick;
        this.entityData.set(DATA_ATTACK_TICK, (Object)this.attackTick);
        if (this.attackTick > 25) {
            return;
        }
        if (this.attackTick == 25) {
            List nearbyPlayers = serverLevel.getEntitiesOfClass(ServerPlayer.class, this.getBoundingBox().inflate(32.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
            if (!nearbyPlayers.isEmpty()) {
                Player targetPlayer = (Player)nearbyPlayers.get(this.random.nextInt(nearbyPlayers.size()));
                this.attack3TargetPos = targetPlayer.blockPosition();
                this.attack3TargetUUID = targetPlayer.getUUID();
                double centerX = (double)this.attack3TargetPos.getX() + 0.5;
                double groundY = this.attack3TargetPos.getY();
                double centerZ = (double)this.attack3TargetPos.getZ() + 0.5;
                int particleCount = 60;
                double spikeHeight = 3.5;
                double upwardSpeed = 0.8;
                for (int i = 0; i < particleCount; ++i) {
                    double offsetX = (this.random.nextDouble() - 0.5) * 0.4;
                    double offsetZ = (this.random.nextDouble() - 0.5) * 0.4;
                    double offsetY = this.random.nextDouble() * spikeHeight;
                    serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)PN_Particles.VINE_PARTICLE.get()), centerX + offsetX, groundY + offsetY, centerZ + offsetZ, 1, 0.0, upwardSpeed * 0.8, 0.0, 0.1);
                }
                serverLevel.playSound(null, this.attack3TargetPos, (SoundEvent)PN_Sounds.PUMPKING_ATTACK_STAB_UP.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            } else {
                this.resetAttackState();
                return;
            }
        }
        if (this.attackTick == 10 && this.attack3TargetPos != null) {
            float damageAmount = 10.0f;
            double damageRadius = 2.5;
            double damageRadiusSqr = damageRadius * damageRadius;
            AABB damageArea = new AABB(this.attack3TargetPos).inflate(damageRadius, 2.0, damageRadius);
            List playersInArea = serverLevel.getEntitiesOfClass(Player.class, damageArea, player -> player.isAlive() && !player.isCreative() && !player.isSpectator());
            DamageSource source = this.damageSources().indirectMagic((Entity)this, (Entity)this);
            boolean hitSomeone = false;
            for (Player player2 : playersInArea) {
                if (!(player2.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.attack3TargetPos)) <= damageRadiusSqr)) continue;
                player2.hurt(source, damageAmount);
                hitSomeone = true;
            }
            serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)PN_Particles.VINE_PARTICLE.get()), (double)this.attack3TargetPos.getX() + 0.5, (double)this.attack3TargetPos.getY() + 0.1, (double)this.attack3TargetPos.getZ() + 0.5, 30, 0.4, 0.2, 0.4, 0.1);
            if (hitSomeone) {
                serverLevel.playSound(null, this.attack3TargetPos, SoundEvents.GENERIC_HURT, SoundSource.HOSTILE, 1.0f, 0.8f);
            } else {
                serverLevel.playSound(null, this.attack3TargetPos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.HOSTILE, 0.5f, 1.5f);
            }
        }
        if (this.attackTick <= 0) {
            this.resetAttackState();
        }
    }

    private void resetAttackState() {
        this.currentAttack = AttackType.NONE;
        this.attackTick = 0;
        this.entityData.set(DATA_ATTACK_TYPE, (Object)this.currentAttack.ordinal());
        this.entityData.set(DATA_ATTACK_TICK, (Object)0);
        this.attack3TargetPos = null;
        this.attack3TargetUUID = null;
        if (!this.onGround()) {
            this.setPos(this.getX(), Math.floor(this.getY()), this.getZ());
        }
        this.setDeltaMovement(Vec3.ZERO);
        this.setOnGround(true);
    }

    private void handleSlamTick(ServerLevel serverLevel, boolean currentOnGround) {
        --this.attackTick;
        this.entityData.set(DATA_ATTACK_TICK, (Object)this.attackTick);
        if (currentOnGround && !this.wasOnGround || this.attackTick <= 0) {
            if (currentOnGround && !this.wasOnGround) {
                this.performAreaDamage();
            }
            this.resetAttackState();
        }
    }

    private void handleLookAtPlayer() {
        Player nearestPlayer = this.level().getNearestPlayer((Entity)this, 32.0);
        if (nearestPlayer != null) {
            Vec3 targetVector = nearestPlayer.position().subtract(this.position());
            double yaw = Math.atan2(targetVector.z, targetVector.x) * 57.29577951308232 - 90.0;
            double pitch = -Math.atan2(targetVector.y, Math.sqrt(targetVector.x * targetVector.x + targetVector.z * targetVector.z)) * 57.29577951308232;
            this.setYRot((float)yaw);
            this.setXRot((float)pitch);
            this.setYHeadRot((float)yaw);
        }
    }

    public boolean isNoAi() {
        return true;
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    private void performAttack1() {
        Level level;
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int count = 4;
            double radius = 12.0;
            for (int i = 0; i < count; ++i) {
                double angle = Math.PI * 2 / (double)count * (double)i;
                double spawnX = this.getX() + Math.cos(angle) * radius;
                double spawnY = this.getY();
                double spawnZ = this.getZ() + Math.sin(angle) * radius;
                BlockPos spawnPos = BlockPos.containing((double)spawnX, (double)spawnY, (double)spawnZ);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.WITCH, spawnX, spawnY + 0.5, spawnZ, 10, 0.3, 0.3, 0.3, 0.05);
                VinelingEntity vineling = (VinelingEntity)PN_Entities.VINELING.get().create((Level)serverLevel);
                if (vineling == null) continue;
                vineling.setPos(spawnX, spawnY, spawnZ);
                Player targetPlayer = serverLevel.getNearestPlayer((Entity)this, 32.0);
                if (targetPlayer != null) {
                    vineling.setTarget((LivingEntity)targetPlayer);
                }
                vineling.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(spawnPos), MobSpawnType.MOB_SUMMONED, null);
                serverLevel.addFreshEntity((Entity)vineling);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "pumpking_controller", 0, this::predicate);
        registrar.add(controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        AttackType currentSyncedAttack = AttackType.values()[(Integer)this.entityData.get(DATA_ATTACK_TYPE)];
        AnimationController controller = event.getController();
        switch (currentSyncedAttack.ordinal()) {
            case 1: {
                String slamAnim = "animation.pumpking.bounce_attack";
                if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals(slamAnim)) {
                    controller.setAnimation(RawAnimation.begin().thenPlay(slamAnim));
                }
                return PlayState.CONTINUE;
            }
            case 3: {
                String strikeAnim = "animation.pumpking.stab_attack";
                if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals(strikeAnim)) {
                    controller.setAnimation(RawAnimation.begin().thenPlay(strikeAnim));
                }
                return PlayState.CONTINUE;
            }
        }
        String idleAnim = "animation.pumpking.idle";
        if (controller.getCurrentAnimation() == null || !controller.getCurrentAnimation().animation().name().equals(idleAnim)) {
            controller.setAnimation(RawAnimation.begin().thenLoop(idleAnim));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 300.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.SCALE, 6.0);
    }

    private static enum AttackType {
        NONE,
        SLAM,
        SUMMON,
        TARGETED_STRIKE;

    }
}

