/*
 * Decompiled with CFR 0.152.
 */
package com.cudzer.pumpkin_nightmares.entity;

import com.cudzer.pumpkin_nightmares.entity.ai.PumpykinsHarvestGoal;
import com.cudzer.pumpkin_nightmares.registry.PN_Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpykinsEntity
extends TamableAnimal
implements GeoEntity,
ContainerListener {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> DATA_IS_HARVESTING = SynchedEntityData.defineId(PumpykinsEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final SimpleContainer inventory = new SimpleContainer(9);

    public PumpykinsEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnGroupData) {
        super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnGroupData);
        this.inventory.addListener((ContainerListener)this);
        return pSpawnGroupData;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.85);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new PumpykinsHarvestGoal(this, 10, 0.3));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.25));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_IS_HARVESTING, (Object)false);
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.level().isClientSide) {
            return this.isOwnedBy((LivingEntity)pPlayer) || this.isTame() ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (this.isOwnedBy((LivingEntity)pPlayer)) {
            this.setOrderedToSit(!this.isOrderedToSit());
            this.jumping = false;
            this.navigation.stop();
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController((GeoAnimatable)this, "pumpykins_controller", 0, this::predicate));
    }

    public void push(@NotNull Entity pEntity) {
        if (pEntity instanceof PumpykinsEntity) {
            return;
        }
        super.push(pEntity);
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (this.isInSittingPose()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.pumpykins.sit"));
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.entityData.get(DATA_IS_HARVESTING)).booleanValue()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("animation.pumpykins.harvest"));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.pumpykins.walk"));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.pumpykins.idle"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        ContainerHelper.saveAllItems((CompoundTag)pCompound, (NonNullList)this.inventory.getItems(), (HolderLookup.Provider)this.level().registryAccess());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        NonNullList items = NonNullList.withSize((int)this.inventory.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)pCompound, (NonNullList)items, (HolderLookup.Provider)this.level().registryAccess());
        this.inventory.clearContent();
        for (int i = 0; i < items.size(); ++i) {
            this.inventory.setItem(i, (ItemStack)items.get(i));
        }
    }

    public boolean isFood(@NotNull ItemStack itemStack) {
        return false;
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource pSource, boolean pRecentlyHit) {
        super.dropCustomDeathLoot(level, pSource, pRecentlyHit);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            this.spawnAtLocation(this.inventory.getItem(i));
        }
    }

    public void setHarvesting(boolean pHarvesting) {
        this.entityData.set(DATA_IS_HARVESTING, (Object)pHarvesting);
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }

    public void containerChanged(@NotNull Container pInv) {
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        SoundEvent customStepSound = (SoundEvent)PN_Sounds.PUMPYKINS_WALK.get();
        this.playSound(customStepSound, 0.15f, 0.8f);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)PN_Sounds.PUMPYKINS_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)PN_Sounds.PUMPYKINS_DEATH.get();
    }
}

