/*
 * Decompiled with CFR 0.152.
 */
package com.cudzer.pumpkin_nightmares.entity.ai;

import com.cudzer.pumpkin_nightmares.entity.PumpykinsEntity;
import com.cudzer.pumpkin_nightmares.registry.PN_Sounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PumpykinsHarvestGoal
extends Goal {
    private final PumpykinsEntity pumpykins;
    private final int radius;
    private final double speed;
    private final Level level;
    private BlockPos targetCrop = null;
    private BlockPos targetChest = null;
    private int harvestsSinceDeposit = 0;
    private static final int HARVESTS_BEFORE_DEPOSIT = 5;
    private int harvestAnimationTicks = 0;

    public PumpykinsHarvestGoal(PumpykinsEntity pumpykins, int radius, double speed) {
        this.pumpykins = pumpykins;
        this.radius = radius;
        this.speed = speed;
        this.level = pumpykins.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.pumpykins.isInSittingPose() || this.level.isClientSide) {
            return false;
        }
        if (this.harvestsSinceDeposit >= 5) {
            this.targetChest = this.findNearestChest();
            return this.targetChest != null;
        }
        this.targetCrop = this.findNearestMatureCrop();
        return this.targetCrop != null;
    }

    public boolean canContinueToUse() {
        return !this.pumpykins.isInSittingPose() && (this.targetCrop != null || this.targetChest != null);
    }

    public void start() {
        if (this.harvestsSinceDeposit >= 5) {
            this.targetChest = this.findNearestChest();
        } else {
            this.targetCrop = this.findNearestMatureCrop();
        }
    }

    public void stop() {
        this.targetCrop = null;
        this.targetChest = null;
        this.pumpykins.getNavigation().stop();
        this.pumpykins.setHarvesting(false);
    }

    public void tick() {
        if (this.targetCrop == null && this.targetChest == null) {
            if (this.harvestsSinceDeposit >= 5) {
                this.targetChest = this.findNearestChest();
            } else {
                this.targetCrop = this.findNearestMatureCrop();
            }
            if (this.targetCrop == null && this.targetChest == null) {
                this.stop();
                return;
            }
        }
        if (this.targetCrop != null) {
            this.pumpykins.getNavigation().moveTo((double)this.targetCrop.getX(), (double)this.targetCrop.getY(), (double)this.targetCrop.getZ(), this.speed);
            double distanceSq = this.pumpykins.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetCrop));
            double reachDistanceSq = 2.25;
            if (distanceSq <= reachDistanceSq) {
                this.pumpykins.getNavigation().stop();
                if (this.harvestAnimationTicks == 0) {
                    this.pumpykins.setHarvesting(true);
                    this.harvestAnimationTicks = 20;
                }
                if (this.harvestAnimationTicks > 0) {
                    --this.harvestAnimationTicks;
                    if (this.harvestAnimationTicks == 5) {
                        this.performHarvest();
                        this.targetCrop = null;
                        this.pumpykins.setHarvesting(false);
                    }
                }
            }
        } else if (this.targetChest != null) {
            this.pumpykins.getNavigation().moveTo((double)this.targetChest.getX(), (double)this.targetChest.getY(), (double)this.targetChest.getZ(), this.speed);
            double distanceSq = this.pumpykins.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetChest));
            double reachDistanceSq = 2.0;
            if (distanceSq <= reachDistanceSq) {
                this.pumpykins.getNavigation().stop();
                this.performDeposit();
                this.targetChest = null;
            }
        } else if (this.harvestsSinceDeposit >= 5) {
            this.targetChest = this.findNearestChest();
        } else {
            this.targetCrop = this.findNearestMatureCrop();
        }
    }

    private void performHarvest() {
        CropBlock crop;
        if (this.targetCrop == null) {
            return;
        }
        BlockState cropState = this.level.getBlockState(this.targetCrop);
        Block cropBlock = cropState.getBlock();
        if (cropBlock instanceof CropBlock && (crop = (CropBlock)cropBlock).isMaxAge(cropState)) {
            ItemStack removedCount;
            ServerLevel serverLevel = (ServerLevel)this.level;
            LootParams.Builder lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.targetCrop));
            List drops = cropState.getDrops(lootParams);
            this.level.setBlock(this.targetCrop, Blocks.AIR.defaultBlockState(), 3);
            Item seedItem = crop.getCloneItemStack((LevelReader)this.level, this.targetCrop, cropState).getItem();
            boolean planted = false;
            for (ItemStack drop : drops) {
                if (!planted && drop.is(seedItem)) {
                    this.level.setBlock(this.targetCrop, cropBlock.defaultBlockState(), 3);
                    drop.shrink(1);
                    planted = true;
                }
                if (drop.isEmpty()) continue;
                this.pumpykins.getInventory().addItem(drop);
            }
            ++this.harvestsSinceDeposit;
            this.pumpykins.playSound((SoundEvent)PN_Sounds.PUMPYKINS_HARVEST.get(), 1.0f, 1.0f);
            if (!(planted || seedItem != Items.POTATO && seedItem != Items.CARROT || (removedCount = this.pumpykins.getInventory().removeItemType(seedItem, 1)).isEmpty())) {
                this.level.setBlock(this.targetCrop, cropBlock.defaultBlockState(), 3);
            }
            if (this.pumpykins.getRandom().nextFloat() < 0.1f) {
                for (int i = 0; i < this.pumpykins.getInventory().getContainerSize(); ++i) {
                    ItemStack item = this.pumpykins.getInventory().getItem(i);
                    if (item.get(DataComponents.FOOD) == null) continue;
                    this.pumpykins.getInventory().removeItem(i, 1);
                    this.pumpykins.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
                    break;
                }
            }
        }
    }

    private void performDeposit() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.targetChest);
        if (blockEntity instanceof Container) {
            Container chestContainer = (Container)blockEntity;
            SimpleContainer pumpykinsInv = this.pumpykins.getInventory();
            boolean depositedSomething = false;
            for (int i = 0; i < pumpykinsInv.getContainerSize(); ++i) {
                int j;
                ItemStack stackToDeposit = pumpykinsInv.getItem(i);
                if (stackToDeposit.isEmpty()) continue;
                for (j = 0; j < chestContainer.getContainerSize(); ++j) {
                    int transferAmount;
                    int space;
                    ItemStack stackInChest = chestContainer.getItem(j);
                    if (stackInChest.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stackToDeposit, (ItemStack)stackInChest) || (space = stackInChest.getMaxStackSize() - stackInChest.getCount()) <= 0 || (transferAmount = Math.min(stackToDeposit.getCount(), space)) <= 0) continue;
                    stackInChest.grow(transferAmount);
                    stackToDeposit.shrink(transferAmount);
                    chestContainer.setItem(j, stackInChest);
                    depositedSomething = true;
                    if (stackToDeposit.isEmpty()) break;
                }
                if (!stackToDeposit.isEmpty()) {
                    for (j = 0; j < chestContainer.getContainerSize(); ++j) {
                        if (!chestContainer.getItem(j).isEmpty()) continue;
                        chestContainer.setItem(j, stackToDeposit.copy());
                        stackToDeposit.setCount(0);
                        depositedSomething = true;
                        break;
                    }
                }
                pumpykinsInv.setItem(i, stackToDeposit.isEmpty() ? ItemStack.EMPTY : stackToDeposit);
            }
            if (depositedSomething) {
                this.harvestsSinceDeposit = 0;
                this.pumpykins.playSound(SoundEvents.ITEM_PICKUP, 0.5f, 1.0f);
            } else {
                this.harvestsSinceDeposit = 0;
            }
        } else {
            this.targetChest = null;
        }
    }

    @Nullable
    private BlockPos findNearestMatureCrop() {
        BlockPos pumpykinsPos = this.pumpykins.blockPosition();
        ArrayList<BlockPos> availableCrops = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)pumpykinsPos.offset(-this.radius, -2, -this.radius), (BlockPos)pumpykinsPos.offset(this.radius, 2, this.radius))) {
            CropBlock crop;
            BlockState state = this.level.getBlockState(pos);
            Block block = state.getBlock();
            if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).isMaxAge(state)) continue;
            availableCrops.add(pos.immutable());
        }
        if (availableCrops.isEmpty()) {
            return null;
        }
        return (BlockPos)availableCrops.get(this.pumpykins.getRandom().nextInt(availableCrops.size()));
    }

    @Nullable
    private BlockPos findNearestChest() {
        BlockPos pumpykinsPos = this.pumpykins.blockPosition();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)pumpykinsPos.offset(-this.radius, -this.radius, -this.radius), (BlockPos)pumpykinsPos.offset(this.radius, this.radius, this.radius))) {
            if (!this.level.getBlockState(pos).is(Blocks.CHEST)) continue;
            return pos.immutable();
        }
        return null;
    }
}

