/*
 * Decompiled with CFR 0.152.
 */
package com.cudzer.pumpkin_nightmares.gui;

import com.cudzer.pumpkin_nightmares.recipe.CarvingRecipe;
import com.cudzer.pumpkin_nightmares.registry.PN_Blocks;
import com.cudzer.pumpkin_nightmares.registry.PN_MenuTypes;
import com.cudzer.pumpkin_nightmares.registry.PN_RecipeTypes;
import com.cudzer.pumpkin_nightmares.registry.PN_Sounds;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class CarvingMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private final Level level;
    private List<RecipeHolder<CarvingRecipe>> recipes = List.of();
    private ItemStack input = ItemStack.EMPTY;
    private long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            CarvingMenu.this.slotsChanged((Container)this);
            CarvingMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public CarvingMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public CarvingMenu(int containerId, Inventory playerInventory, final ContainerLevelAccess access) {
        super((MenuType)PN_MenuTypes.CARVING_MENU.get(), containerId);
        this.access = access;
        this.level = playerInventory.player.level();
        this.inputSlot = this.addSlot(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
                stack.onCraftedBy(player.level(), player, stack.getCount());
                CarvingMenu.this.resultContainer.awardUsedRecipes(player, List.of(CarvingMenu.this.inputSlot.getItem()));
                ItemStack itemstack = CarvingMenu.this.inputSlot.remove(1);
                if (!itemstack.isEmpty()) {
                    CarvingMenu.this.setupResultSlot();
                }
                access.execute((level, blockPos) -> {
                    long gameTime = level.getGameTime();
                    if (CarvingMenu.this.lastSoundTime != gameTime) {
                        level.playSound(null, blockPos, (SoundEvent)PN_Sounds.CARVING_TABLE_USE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        CarvingMenu.this.lastSoundTime = gameTime;
                    }
                });
                super.onTake(player, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlot(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public List<RecipeHolder<CarvingRecipe>> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipes.isEmpty();
    }

    public boolean stillValid(@NotNull Player player) {
        return CarvingMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)PN_Blocks.CARVING_TABLE.get());
    }

    public boolean clickMenuButton(@NotNull Player player, int buttonId) {
        if (this.isValidRecipeIndex(buttonId)) {
            this.selectedRecipeIndex.set(buttonId);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int index) {
        return index >= 0 && index < this.recipes.size();
    }

    public void slotsChanged(@NotNull Container container) {
        ItemStack itemstack = this.inputSlot.getItem();
        if (!itemstack.is(this.input.getItem())) {
            this.input = itemstack.copy();
            this.setupRecipeList(itemstack);
        }
    }

    private void setupRecipeList(ItemStack inputStack) {
        this.recipes = List.of();
        this.selectedRecipeIndex.set(-1);
        this.resultSlot.set(ItemStack.EMPTY);
        if (!inputStack.isEmpty()) {
            this.recipes = this.level.getRecipeManager().getRecipesFor((RecipeType)PN_RecipeTypes.CARVING_TYPE.get(), (RecipeInput)new SingleRecipeInput(inputStack), this.level);
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            RecipeHolder<CarvingRecipe> recipeHolder = this.recipes.get(this.selectedRecipeIndex.get());
            ItemStack result = ((CarvingRecipe)recipeHolder.value()).assemble(new SingleRecipeInput(this.container.getItem(0)), (HolderLookup.Provider)this.level.registryAccess());
            this.resultContainer.setRecipeUsed(recipeHolder);
            this.resultSlot.set(result);
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    @NotNull
    public MenuType<?> getType() {
        return (MenuType)PN_MenuTypes.CARVING_MENU.get();
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack pStack, Slot pSlot) {
        return pSlot != this.resultSlot && super.canTakeItemForPickAll(pStack, pSlot);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            Item item = itemstack1.getItem();
            itemstack = itemstack1.copy();
            if (index == 1) {
                item.onCraftedBy(itemstack1, player.level(), player);
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index == 0 || index >= 2 && index < 38 ? (this.canPutInInputSlot(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false))) : !this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    private boolean canPutInInputSlot(ItemStack stack) {
        return this.level.getRecipeManager().getRecipesFor((RecipeType)PN_RecipeTypes.CARVING_TYPE.get(), (RecipeInput)new SingleRecipeInput(stack), this.level).stream().anyMatch(holder -> ((CarvingRecipe)holder.value()).matches(new SingleRecipeInput(stack), this.level));
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((level, blockPos) -> this.clearContainer(player, this.container));
    }
}

