/*
 * Decompiled with CFR 0.152.
 */
package com.cudzer.pumpkin_nightmares.gui.client.screen;

import com.cudzer.pumpkin_nightmares.gui.CarvingMenu;
import com.cudzer.pumpkin_nightmares.recipe.CarvingRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class CarvingScreen
extends AbstractContainerScreen<CarvingMenu> {
    private static final ResourceLocation BG_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"pumpkin_nightmares", (String)"textures/gui/carving_table.png");
    private static final int SCROLLBAR_HANDLE_U_ACTIVE = 0;
    private static final int SCROLLBAR_HANDLE_V_ACTIVE = 229;
    private static final int SCROLLBAR_HANDLE_U_INACTIVE = 12;
    private static final int SCROLLBAR_HANDLE_V_INACTIVE = 229;
    private static final int SCROLLBAR_HANDLE_WIDTH = 12;
    private static final int SCROLLBAR_HANDLE_HEIGHT = 15;
    private static final ResourceLocation VANILLA_WIDGETS = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/scroller.png");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public CarvingScreen(CarvingMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        pMenu.registerUpdateListener(this::containerChanged);
        --this.titleLabelY;
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int left = this.leftPos;
        int top = this.topPos;
        graphics.blit(BG_LOCATION, left, top, 0, 0, this.imageWidth, this.imageHeight);
        int scrollbarX = left + 119;
        int scrollbarY = top + 15;
        int scrollbarHeight = 56;
        int scrollbarYOffset = (int)((float)scrollbarHeight * this.scrollOffs);
        graphics.blit(BG_LOCATION, scrollbarX, scrollbarY, 176, 15, 12, scrollbarHeight);
        int scrollbarVisibleHeight = 56;
        int scrollHandleYOffset = (int)((float)(scrollbarVisibleHeight - 15) * this.scrollOffs);
        int handleU = 12;
        int handleV = 229;
        if (this.isScrollBarActive()) {
            handleU = 0;
            handleV = 229;
        }
        graphics.blit(VANILLA_WIDGETS, scrollbarX, scrollbarY + scrollHandleYOffset, handleU, handleV, 12, 15);
        int recipeListX = left + 52;
        int recipeListY = top + 14;
        int endIndex = this.startIndex + 12;
        this.renderButtons(graphics, mouseX, mouseY, recipeListX, recipeListY, endIndex);
        this.renderRecipes(graphics, recipeListX, recipeListY, endIndex);
        if (this.displayRecipes && !((CarvingMenu)this.menu).getRecipes().isEmpty()) {
            List<RecipeHolder<CarvingRecipe>> recipes = ((CarvingMenu)this.menu).getRecipes();
            for (int i = this.startIndex; i < endIndex && i < recipes.size(); ++i) {
                int rowOffset = i - this.startIndex;
                int buttonX = recipeListX + rowOffset % 4 * 16;
                int buttonY = recipeListY + rowOffset / 4 * 18;
                if (mouseX < buttonX || mouseY < buttonY || mouseX >= buttonX + 16 || mouseY >= buttonY + 18) continue;
                ItemStack resultItem = ((CarvingRecipe)recipes.get(i).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess());
                graphics.renderTooltip(this.font, resultItem, mouseX, mouseY);
                break;
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int endIndex = this.startIndex + 12;
        for (int i = this.startIndex; i < endIndex; ++i) {
            double relX = mouseX - (double)(this.leftPos + 52);
            double relY = mouseY - (double)(this.topPos + 14);
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d2 = relX - (double)(i1 % 4 * 16);
                double d3 = relY - (double)(i1 / 4 * 18);
                if (!(d2 >= 0.0) || !(d3 >= 0.0) || !(d2 < 16.0) || !(d3 < 18.0) || !((CarvingMenu)this.menu).clickMenuButton((Player)this.minecraft.player, l)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((CarvingMenu)this.menu).containerId, l);
                return true;
            }
            int scrollbarX = this.leftPos + 119;
            int scrollbarY = this.topPos + 9;
            if (!(mouseX >= (double)scrollbarX) || !(mouseX < (double)(scrollbarX + 12)) || !(mouseY >= (double)scrollbarY) || !(mouseY < (double)(scrollbarY + 56 + 15))) continue;
            this.scrolling = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int scrollbarTop = this.topPos + 14;
            int scrollbarBottom = scrollbarTop + 56;
            this.scrollOffs = ((float)mouseY - (float)scrollbarTop - 7.5f) / ((float)(scrollbarBottom - scrollbarTop) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double pScrollX, double pScrollY) {
        if (this.isScrollBarActive()) {
            int rows = this.getOffscreenRows();
            float scrollStep = (float)pScrollY / (float)rows;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - scrollStep), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)rows) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((CarvingMenu)this.menu).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((CarvingMenu)this.menu).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((CarvingMenu)this.menu).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }

    private void renderButtons(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int endIndex) {
        for (int i = this.startIndex; i < endIndex && i < ((CarvingMenu)this.menu).getNumRecipes(); ++i) {
            int row = i - this.startIndex;
            int buttonX = x + row % 4 * 16;
            int buttonY = y + row / 4 * 18 + 2;
            int textureY = this.imageHeight;
            if (i == ((CarvingMenu)this.menu).getSelectedRecipeIndex()) {
                textureY += 18;
            } else if (mouseX >= buttonX && mouseY >= buttonY && mouseX < buttonX + 16 && mouseY < buttonY + 18) {
                textureY += 36;
            }
            graphics.blit(BG_LOCATION, buttonX, buttonY - 1, 0, textureY, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics graphics, int x, int y, int endIndex) {
        List<RecipeHolder<CarvingRecipe>> list = ((CarvingMenu)this.menu).getRecipes();
        for (int i = this.startIndex; i < endIndex && i < list.size(); ++i) {
            int row = i - this.startIndex;
            int itemX = x + row % 4 * 16;
            int itemY = y + row / 4 * 18 + 2;
            graphics.renderItem(((CarvingRecipe)list.get(i).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), itemX, itemY);
        }
    }
}

