/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.block;

import dev.sterner.the_catamount.block.AbstractMonstrousSkeletonBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MonstrousRemainsBlock
extends AbstractMonstrousSkeletonBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<PartType> PART = EnumProperty.create((String)"part", PartType.class);

    public MonstrousRemainsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)PartType.CORE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((PartType)((Object)state.getValue(PART))).getShape();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (this.canPlaceMultiblock(level, pos, facing)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(PART, (Comparable)((Object)PartType.CORE));
        }
        return null;
    }

    private boolean canPlaceMultiblock(Level level, BlockPos corePos, Direction facing) {
        for (PartType part : PartType.values()) {
            BlockPos partPos;
            if (part == PartType.CORE || level.getBlockState(partPos = corePos.offset(part.getOffset(facing))).canBeReplaced()) continue;
            return false;
        }
        return true;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            for (PartType part : PartType.values()) {
                if (part == PartType.CORE) continue;
                BlockPos partPos = pos.offset(part.getOffset(facing));
                level.setBlock(partPos, (BlockState)state.setValue(PART, (Comparable)((Object)part)), 3);
            }
        }
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public static enum PartType implements StringRepresentable
    {
        CORE(0, 0, Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)),
        FRONT(1, 0, Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0)),
        LEFT(0, -1, Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0)),
        RIGHT(0, 1, Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));

        private final int offsetX;
        private final int offsetZ;
        private final VoxelShape shape;

        private PartType(int offsetX, int offsetZ, VoxelShape shape) {
            this.offsetX = offsetX;
            this.offsetZ = offsetZ;
            this.shape = shape;
        }

        public VoxelShape getShape() {
            return this.shape;
        }

        public Vec3i getOffset(Direction facing) {
            return switch (facing) {
                case Direction.NORTH -> new Vec3i(-this.offsetX, 0, -this.offsetZ);
                case Direction.SOUTH -> new Vec3i(this.offsetX, 0, this.offsetZ);
                case Direction.WEST -> new Vec3i(-this.offsetZ, 0, this.offsetX);
                case Direction.EAST -> new Vec3i(this.offsetZ, 0, -this.offsetX);
                default -> Vec3i.ZERO;
            };
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

