/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PetroglyphBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<PetroglyphPart> PART = EnumProperty.create((String)"part", PetroglyphPart.class);

    public PetroglyphBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)PetroglyphPart.SINGLE)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return PetroglyphBlock.simpleCodec(PetroglyphBlock::new);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction dir = context.getHorizontalDirection();
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            dir = dir.getOpposite();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide && !oldState.is((Block)this)) {
            this.checkAndFormMultiblock(level, pos, state);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide && !newState.is((Block)this)) {
            this.breakMultiblock(level, pos, state);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private void checkAndFormMultiblock(Level level, BlockPos pos, BlockState state) {
        BlockPos bottomRight;
        BlockPos bottomLeft;
        BlockPos topLeft = pos;
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction right = facing.getClockWise();
        BlockPos topRight = pos.relative(right);
        if (this.canFormMultiblock(level, topLeft, topRight, bottomLeft = pos.relative(Direction.DOWN), bottomRight = pos.relative(right).relative(Direction.DOWN), facing)) {
            this.formMultiblock(level, topLeft, topRight, bottomLeft, bottomRight, facing);
        } else {
            this.tryFormFromPosition(level, pos, facing, right);
        }
    }

    private void tryFormFromPosition(Level level, BlockPos pos, Direction facing, Direction right) {
        BlockPos br;
        BlockPos bl;
        BlockPos tr;
        BlockPos tl = pos.relative(right.getOpposite());
        if (this.canFormMultiblock(level, tl, tr = pos, bl = pos.relative(right.getOpposite()).relative(Direction.DOWN), br = pos.relative(Direction.DOWN), facing)) {
            this.formMultiblock(level, tl, tr, bl, br, facing);
            return;
        }
        tl = pos.relative(Direction.UP);
        if (this.canFormMultiblock(level, tl, tr = pos.relative(right).relative(Direction.UP), bl = pos, br = pos.relative(right), facing)) {
            this.formMultiblock(level, tl, tr, bl, br, facing);
            return;
        }
        tl = pos.relative(right.getOpposite()).relative(Direction.UP);
        if (this.canFormMultiblock(level, tl, tr = pos.relative(Direction.UP), bl = pos.relative(right.getOpposite()), br = pos, facing)) {
            this.formMultiblock(level, tl, tr, bl, br, facing);
        }
    }

    private boolean canFormMultiblock(Level level, BlockPos topLeft, BlockPos topRight, BlockPos bottomLeft, BlockPos bottomRight, Direction facing) {
        return this.isValidPetroglyphForMultiblock(level, topLeft, facing) && this.isValidPetroglyphForMultiblock(level, topRight, facing) && this.isValidPetroglyphForMultiblock(level, bottomLeft, facing) && this.isValidPetroglyphForMultiblock(level, bottomRight, facing);
    }

    private boolean isValidPetroglyphForMultiblock(Level level, BlockPos pos, Direction facing) {
        BlockState state = level.getBlockState(pos);
        return state.is((Block)this) && state.getValue((Property)FACING) == facing && state.getValue(PART) == PetroglyphPart.SINGLE;
    }

    private void formMultiblock(Level level, BlockPos topLeft, BlockPos topRight, BlockPos bottomLeft, BlockPos bottomRight, Direction facing) {
        level.setBlock(topLeft, (BlockState)level.getBlockState(topLeft).setValue(PART, (Comparable)((Object)PetroglyphPart.TOP_LEFT)), 3);
        level.setBlock(topRight, (BlockState)level.getBlockState(topRight).setValue(PART, (Comparable)((Object)PetroglyphPart.TOP_RIGHT)), 3);
        level.setBlock(bottomLeft, (BlockState)level.getBlockState(bottomLeft).setValue(PART, (Comparable)((Object)PetroglyphPart.BOTTOM_LEFT)), 3);
        level.setBlock(bottomRight, (BlockState)level.getBlockState(bottomRight).setValue(PART, (Comparable)((Object)PetroglyphPart.BOTTOM_RIGHT)), 3);
    }

    private void breakMultiblock(Level level, BlockPos pos, BlockState state) {
        BlockPos bottomRight;
        BlockPos bottomLeft;
        BlockPos topRight;
        BlockPos topLeft;
        PetroglyphPart part = (PetroglyphPart)((Object)state.getValue(PART));
        if (part == PetroglyphPart.SINGLE) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction right = facing.getClockWise();
        switch (part.ordinal()) {
            case 1: {
                topLeft = pos;
                topRight = pos.relative(right);
                bottomLeft = pos.relative(Direction.DOWN);
                bottomRight = pos.relative(right).relative(Direction.DOWN);
                break;
            }
            case 2: {
                topLeft = pos.relative(right.getOpposite());
                topRight = pos;
                bottomLeft = pos.relative(right.getOpposite()).relative(Direction.DOWN);
                bottomRight = pos.relative(Direction.DOWN);
                break;
            }
            case 3: {
                topLeft = pos.relative(Direction.UP);
                topRight = pos.relative(right).relative(Direction.UP);
                bottomLeft = pos;
                bottomRight = pos.relative(right);
                break;
            }
            case 4: {
                topLeft = pos.relative(right.getOpposite()).relative(Direction.UP);
                topRight = pos.relative(Direction.UP);
                bottomLeft = pos.relative(right.getOpposite());
                bottomRight = pos;
                break;
            }
            default: {
                return;
            }
        }
        this.resetToSingle(level, topLeft);
        this.resetToSingle(level, topRight);
        this.resetToSingle(level, bottomLeft);
        this.resetToSingle(level, bottomRight);
    }

    private void resetToSingle(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.is((Block)this) && state.getValue(PART) != PetroglyphPart.SINGLE) {
            level.setBlock(pos, (BlockState)state.setValue(PART, (Comparable)((Object)PetroglyphPart.SINGLE)), 3);
        }
    }

    public static enum PetroglyphPart implements StringRepresentable
    {
        SINGLE("single"),
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right"),
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right");

        private final String name;

        private PetroglyphPart(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

