/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.block;

import dev.sterner.the_catamount.block.SuspiciousDirtBlock;
import dev.sterner.the_catamount.registry.TCBlockEntityTypes;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;

public class SuspiciousDirtBlockEntity
extends BlockEntity {
    private int brushProgress = 0;
    private long brushResetTime = 0L;
    private long coolDownEndsAtTick = 0L;
    private ItemStack storedItem = ItemStack.EMPTY;
    private Direction hitDirection = null;
    private ResourceKey<LootTable> lootTable = null;
    private long lootTableSeed = 0L;

    public SuspiciousDirtBlockEntity(BlockPos pos, BlockState state) {
        super(TCBlockEntityTypes.SUSPICIOUS_DIRT, pos, state);
    }

    public boolean brush(long startTick, Player player, Direction hitDirection) {
        Level level;
        if (this.hitDirection == null) {
            this.hitDirection = hitDirection;
        }
        this.brushResetTime = startTick + 40L;
        if (startTick >= this.coolDownEndsAtTick && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.coolDownEndsAtTick = startTick + 10L;
            this.unpackLootTable(player);
            int prevState = this.getCompletionState();
            ++this.brushProgress;
            if (this.brushProgress >= 10) {
                this.onBrushingCompleted(player);
                return true;
            }
            this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 2);
            int newState = this.getCompletionState();
            if (prevState != newState) {
                BlockState newBlockState = (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.DUSTED, (Comparable)Integer.valueOf(newState));
                this.level.setBlock(this.worldPosition, newBlockState, 3);
            }
            return false;
        }
        return false;
    }

    private void unpackLootTable(Player player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.storedItem.isEmpty()) {
                List<ItemStack> list = List.of(Items.BONE.getDefaultInstance(), Items.ROTTEN_FLESH.getDefaultInstance(), Items.SKELETON_SKULL.getDefaultInstance());
                RandomSource random = serverLevel.getRandom();
                this.storedItem = list.get(random.nextInt(list.size() - 1));
                this.lootTable = null;
                this.setChanged();
            }
        }
    }

    private void onBrushingCompleted(Player player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            Block replacementBlock;
            ServerLevel serverLevel = (ServerLevel)level;
            this.dropLoot(player);
            BlockState currentState = this.getBlockState();
            this.level.levelEvent(3008, this.worldPosition, Block.getId((BlockState)currentState));
            Block block = currentState.getBlock();
            if (block instanceof SuspiciousDirtBlock) {
                SuspiciousDirtBlock graveyardBlock = (SuspiciousDirtBlock)block;
                replacementBlock = graveyardBlock.turnsInto;
            } else {
                replacementBlock = Blocks.AIR;
            }
            this.level.setBlock(this.worldPosition, replacementBlock.defaultBlockState(), 3);
        }
    }

    private void dropLoot(Player player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.unpackLootTable(player);
            if (!this.storedItem.isEmpty()) {
                double entityWidth = EntityType.ITEM.getWidth();
                double posOffset = 1.0 - entityWidth;
                double halfWidth = entityWidth / 2.0;
                Direction dropDir = Objects.requireNonNullElse(this.hitDirection, Direction.UP);
                BlockPos dropPos = this.worldPosition.relative(dropDir, 1);
                double x = (double)dropPos.getX() + 0.5 * posOffset + halfWidth;
                double y = (double)dropPos.getY() + 0.5 + (double)(EntityType.ITEM.getHeight() / 2.0f);
                double z = (double)dropPos.getZ() + 0.5 * posOffset + halfWidth;
                ItemEntity itemEntity = new ItemEntity(this.level, x, y, z, this.storedItem.split(serverLevel.getRandom().nextInt(21) + 10));
                itemEntity.setDeltaMovement(Vec3.ZERO);
                this.level.addFreshEntity((Entity)itemEntity);
                this.storedItem = ItemStack.EMPTY;
            }
        }
    }

    public void resetBrushingState() {
        if (this.level == null) {
            return;
        }
        long gameTime = this.level.getGameTime();
        if (this.brushProgress != 0 && gameTime >= this.brushResetTime) {
            int oldState = this.getCompletionState();
            this.brushProgress = (int)Math.max(0.0, (double)this.brushProgress - 2.0);
            int newState = this.getCompletionState();
            if (oldState != newState) {
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.DUSTED, (Comparable)Integer.valueOf(newState)), 3);
            }
            this.brushResetTime = gameTime + 4L;
        }
        if (this.brushProgress == 0) {
            this.hitDirection = null;
            this.brushResetTime = 0L;
        } else {
            this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 2);
        }
    }

    private boolean tryLoadLootTable(CompoundTag tag) {
        if (tag.contains("LootTable", 8)) {
            this.lootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)tag.getString("LootTable")));
            this.lootTableSeed = tag.getLong("LootTableSeed");
            return true;
        }
        return false;
    }

    private boolean trySaveLootTable(CompoundTag tag) {
        if (this.lootTable == null) {
            return false;
        }
        tag.putString("LootTable", this.lootTable.location().toString());
        if (this.lootTableSeed != 0L) {
            tag.putLong("LootTableSeed", this.lootTableSeed);
        }
        return true;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        if (this.hitDirection != null) {
            tag.putInt("hit_direction", this.hitDirection.ordinal());
        }
        if (!this.storedItem.isEmpty()) {
            tag.put("item", this.storedItem.save(registries));
        }
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.storedItem = !this.tryLoadLootTable(tag) && tag.contains("item") ? ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("item")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        if (tag.contains("hit_direction")) {
            this.hitDirection = Direction.values()[tag.getInt("hit_direction")];
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag) && !this.storedItem.isEmpty()) {
            tag.put("item", this.storedItem.save(registries));
        }
    }

    public void setLootTable(ResourceKey<LootTable> lootTable, long seed) {
        this.lootTable = lootTable;
        this.lootTableSeed = seed;
    }

    private int getCompletionState() {
        if (this.brushProgress == 0) {
            return 0;
        }
        if (this.brushProgress < 3) {
            return 1;
        }
        if (this.brushProgress < 6) {
            return 2;
        }
        return 3;
    }

    public ItemStack getStoredItem() {
        return this.storedItem;
    }

    public Direction getHitDirection() {
        return this.hitDirection;
    }
}

