/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.catamount_events;

import dev.sterner.the_catamount.catamount_events.EventType;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class CatamountEvent {
    private final EventType type;
    private final boolean countsTowardsPoints;
    private final int weight;

    public CatamountEvent(EventType type, boolean countsTowardsPoints, int weight) {
        this.type = type;
        this.countsTowardsPoints = countsTowardsPoints;
        this.weight = weight;
    }

    public CatamountEvent(EventType type, boolean countsTowardsPoints) {
        this(type, countsTowardsPoints, 1);
    }

    public EventType getType() {
        return this.type;
    }

    public boolean countsTowardsPoints() {
        return this.countsTowardsPoints;
    }

    public int getWeight() {
        return this.weight;
    }

    public abstract void execute(ServerPlayer var1);

    public boolean canExecute(ServerPlayer player) {
        return true;
    }

    protected void addPoints(ServerPlayer player, int points) {
        CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)player);
        CatamountPlayerDataAttachment.setData((Player)player, data.addPoints(points));
    }

    protected BlockPos getEventLocation(ServerPlayer player) {
        RandomSource random = player.getRandom();
        ServerLevel level = player.serverLevel();
        if (random.nextBoolean()) {
            return player.blockPosition().offset(random.nextInt(32) - 16, random.nextInt(16) - 8, random.nextInt(32) - 16);
        }
        BlockPos spawnPoint = player.getRespawnPosition();
        ResourceKey spawnDimension = player.getRespawnDimension();
        if (spawnPoint != null && spawnDimension == level.dimension()) {
            return spawnPoint.offset(random.nextInt(32) - 16, random.nextInt(16) - 8, random.nextInt(32) - 16);
        }
        BlockPos worldSpawn = level.getSharedSpawnPos();
        return worldSpawn.offset(random.nextInt(32) - 16, random.nextInt(16) - 8, random.nextInt(32) - 16);
    }

    protected <T extends Entity> List<T> findNearbyEntities(ServerPlayer player, Class<T> entityClass, double radius) {
        return player.level().getEntitiesOfClass(entityClass, player.getBoundingBox().inflate(radius));
    }
}

