/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.catamount_events;

import dev.sterner.the_catamount.catamount_events.CatamountEvent;
import dev.sterner.the_catamount.catamount_events.EventType;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.data_attachment.DangerousLeavesDataAttachment;
import dev.sterner.the_catamount.entity.WindEntity;
import dev.sterner.the_catamount.registry.TCEntityTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DamagingEvents {
    public static List<CatamountEvent> getAll() {
        return List.of(new StealFoodEvent(), new DangerousLeavesEvent(), new DangerousWindEvent());
    }

    public static class StealFoodEvent
    extends CatamountEvent {
        public StealFoodEvent() {
            super(EventType.DAMAGING, true);
        }

        @Override
        public void execute(ServerPlayer player) {
            int stolenCount = 0;
            BlockPos searchCenter = this.getEventLocation(player);
            ServerLevel level = player.serverLevel();
            block0: for (BlockPos pos : BlockPos.betweenClosed((BlockPos)searchCenter.offset(-16, -8, -16), (BlockPos)searchCenter.offset(16, 8, 16))) {
                AbstractFurnaceBlockEntity furnace;
                ItemStack result;
                if (stolenCount >= 5) break;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof AbstractFurnaceBlockEntity && (result = (furnace = (AbstractFurnaceBlockEntity)blockEntity).getItem(2)).has(DataComponents.FOOD)) {
                    int toSteal = Math.min(result.getCount(), 5 - stolenCount);
                    result.shrink(toSteal);
                    stolenCount += toSteal;
                }
                if (!(blockEntity instanceof CampfireBlockEntity)) continue;
                CampfireBlockEntity campfire = (CampfireBlockEntity)blockEntity;
                for (int i = 0; i < 4; ++i) {
                    ItemStack item = (ItemStack)campfire.getItems().get(i);
                    if (item.isEmpty()) continue;
                    campfire.getItems().set(i, (Object)ItemStack.EMPTY);
                    if (++stolenCount >= 5) continue block0;
                }
            }
            List items = level.getEntitiesOfClass(ItemEntity.class, new AABB(searchCenter).inflate(16.0));
            for (ItemEntity itemEntity : items) {
                if (stolenCount >= 5) break;
                ItemStack stack = itemEntity.getItem();
                if (!stack.has(DataComponents.FOOD)) continue;
                int toSteal = Math.min(stack.getCount(), 5 - stolenCount);
                stack.shrink(toSteal);
                stolenCount += toSteal;
                if (!stack.isEmpty()) continue;
                itemEntity.discard();
            }
            if (stolenCount > 0) {
                this.addPoints(player, stolenCount);
                level.playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.AMBIENT, 0.5f, 0.8f);
            }
        }
    }

    public static class DangerousLeavesEvent
    extends CatamountEvent {
        private static final int DURATION = 600;

        public DangerousLeavesEvent() {
            super(EventType.DAMAGING, true);
        }

        @Override
        public void execute(ServerPlayer player) {
            BlockPos center = this.getEventLocation(player);
            ServerLevel level = player.serverLevel();
            ArrayList<BlockPos> dangerousLeaves = new ArrayList<BlockPos>();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)center.offset(-10, -5, -10), (BlockPos)center.offset(10, 5, 10))) {
                BlockState state = level.getBlockState(pos);
                if (!state.is(BlockTags.LEAVES) || state.hasBlockEntity()) continue;
                dangerousLeaves.add(pos.immutable());
            }
            if (!dangerousLeaves.isEmpty()) {
                DangerousLeavesDataAttachment.Data data = DangerousLeavesDataAttachment.getData(level);
                long endTime = level.getGameTime() + 600L;
                for (BlockPos pos : dangerousLeaves) {
                    data = data.withDangerousLeaf(pos, endTime);
                }
                DangerousLeavesDataAttachment.setData(level, data);
                level.sendParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, (double)center.getX() + 0.5, (double)center.getY() + 0.5, (double)center.getZ() + 0.5, 20, 5.0, 2.0, 5.0, 0.05);
                level.playSound(null, center, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.AMBIENT, 0.8f, 0.6f);
            }
        }

        public static void tickDangerousLeaves(ServerPlayer player) {
            BlockPos playerPos = player.blockPosition();
            ServerLevel level = player.serverLevel();
            DangerousLeavesDataAttachment.Data data = DangerousLeavesDataAttachment.getData(level);
            long currentTime = level.getGameTime();
            for (BlockPos pos : new ArrayList<BlockPos>(data.dangerousLeaves().keySet())) {
                BlockState state;
                long endTime = data.dangerousLeaves().get(pos);
                if (currentTime >= endTime) {
                    data = data.withoutDangerousLeaf(pos);
                    continue;
                }
                if (!(playerPos.distSqr((Vec3i)pos) <= 9.0) || !(state = level.getBlockState(pos)).is(BlockTags.LEAVES) || state.hasBlockEntity()) continue;
                if (level.getGameTime() % 40L != 0L) break;
                float damage = 1.0f + player.getRandom().nextFloat();
                if (player.getHealth() > damage) {
                    player.hurt(level.damageSources().magic(), damage);
                    CatamountPlayerDataAttachment.Data pData = CatamountPlayerDataAttachment.getData((Player)player);
                    CatamountPlayerDataAttachment.setData((Player)player, pData.addPoints((int)damage));
                } else {
                    player.hurt(level.damageSources().magic(), 0.0f);
                }
                level.sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, player.getX(), player.getY() + 1.0, player.getZ(), 5, 0.5, 0.5, 0.5, 0.1);
                break;
            }
            DangerousLeavesDataAttachment.setData(level, data);
        }
    }

    public static class DangerousWindEvent
    extends CatamountEvent {
        public DangerousWindEvent() {
            super(EventType.DAMAGING, true);
        }

        @Override
        public void execute(ServerPlayer player) {
            BlockPos location = this.getEventLocation(player);
            ServerLevel level = player.serverLevel();
            WindEntity wind = new WindEntity(TCEntityTypes.WIND, (Level)level);
            wind.setPos((double)location.getX() + 0.5, location.getY(), (double)location.getZ() + 0.5);
            wind.setAggressive(true);
            wind.setTargetPlayer(player.getUUID());
            level.addFreshEntity((Entity)wind);
            level.playSound(null, location, (SoundEvent)SoundEvents.BREEZE_WIND_CHARGE_BURST.value(), SoundSource.HOSTILE, 1.0f, 0.8f);
        }
    }
}

