/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.client;

import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;

public class ClientFogEffectTracker {
    private static long fogEndTime = 0L;
    private static long fogStartTime = 0L;
    private static Vec3 fogCenter = Vec3.ZERO;
    private static float fogRadius = 64.0f;
    private static final int FADE_IN_TIME = 100;
    private static final int FADE_OUT_TIME = 100;

    public static void setFogEffect(Vec3 center, float radius, int durationTicks) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        fogCenter = center;
        fogRadius = radius;
        fogStartTime = Minecraft.getInstance().level.getGameTime();
        fogEndTime = fogStartTime + (long)durationTicks;
    }

    public static void clearFog() {
        fogEndTime = 0L;
        fogStartTime = 0L;
    }

    public static boolean hasFogEffect() {
        if (Minecraft.getInstance().level == null) {
            return false;
        }
        return Minecraft.getInstance().level.getGameTime() < fogEndTime;
    }

    public static float getFogTransition() {
        if (!ClientFogEffectTracker.hasFogEffect() || Minecraft.getInstance().level == null) {
            return 0.0f;
        }
        long currentTime = Minecraft.getInstance().level.getGameTime();
        long elapsed = currentTime - fogStartTime;
        long remaining = fogEndTime - currentTime;
        if (elapsed < 100L) {
            return (float)elapsed / 100.0f;
        }
        if (remaining < 100L) {
            return (float)remaining / 100.0f;
        }
        return 1.0f;
    }

    public static float getFogDensity(Vec3 playerPos) {
        if (!ClientFogEffectTracker.hasFogEffect()) {
            return 0.0f;
        }
        double distance = playerPos.distanceTo(fogCenter);
        if (distance > (double)fogRadius) {
            return 0.0f;
        }
        float transition = ClientFogEffectTracker.getFogTransition();
        float density = 1.0f - (float)(distance / (double)fogRadius);
        return Math.min(1.0f, density * 0.8f * transition);
    }

    public static float getSkyDarkness(Vec3 playerPos) {
        if (!ClientFogEffectTracker.hasFogEffect()) {
            return 0.0f;
        }
        double distance = playerPos.distanceTo(fogCenter);
        if (distance > (double)fogRadius) {
            return 0.0f;
        }
        float transition = ClientFogEffectTracker.getFogTransition();
        float darkness = 1.0f - (float)(distance / (double)fogRadius);
        return Math.min(0.85f, darkness * transition);
    }

    public static void tick() {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        long currentTime = Minecraft.getInstance().level.getGameTime();
        if (currentTime >= fogEndTime) {
            fogEndTime = 0L;
            fogStartTime = 0L;
        }
    }
}

