/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;

public class StrugglingSpiritParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private int trailTimer = 0;

    protected StrugglingSpiritParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprites = sprites;
        this.friction = 0.96f;
        this.gravity = 0.0f;
        this.speedUpWhenYMotionIsBlocked = false;
        this.xd = (Math.random() - 0.5) * 0.02;
        this.yd = (Math.random() - 0.5) * 0.01;
        this.zd = (Math.random() - 0.5) * 0.02;
        this.quadSize = 0.5f;
        this.lifetime = 100;
        this.setSpriteFromAge(sprites);
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.alpha = 0.0f;
    }

    public void tick() {
        super.tick();
        this.alpha = this.age < 20 ? (float)this.age / 20.0f : (this.age > this.lifetime - 20 ? (float)(this.lifetime - this.age) / 20.0f : 1.0f);
        ++this.trailTimer;
        if (this.trailTimer >= 3 && this.alpha > 0.3f) {
            this.spawnTrailParticles();
            this.trailTimer = 0;
        }
        this.setSpriteFromAge(this.sprites);
    }

    private void spawnTrailParticles() {
        for (int i = 0; i < this.level.random.nextInt(2) + 1; ++i) {
            double offsetX = (this.level.random.nextDouble() - 0.5) * 0.1;
            double offsetY = (this.level.random.nextDouble() - 0.5) * 0.1;
            double offsetZ = (this.level.random.nextDouble() - 0.5) * 0.1;
            double velocityX = (this.level.random.nextDouble() - 0.5) * 0.03;
            double velocityY = -0.02;
            double velocityZ = (this.level.random.nextDouble() - 0.5) * 0.03;
            this.level.addParticle((ParticleOptions)ParticleTypes.SOUL, this.x + offsetX, this.y + offsetY, this.z + offsetZ, velocityX, velocityY, velocityZ);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new StrugglingSpiritParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

