/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.data_attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.sterner.the_catamount.TheCatamount;
import dev.sterner.the_catamount.data_attachment.neoforge.CatamountPlayerDataAttachmentImpl;
import dev.sterner.the_catamount.entity.CatamountEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CatamountPlayerDataAttachment {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Data getData(Player player) {
        return CatamountPlayerDataAttachmentImpl.getData(player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setData(Player player, Data data) {
        void var1_1;
        CatamountPlayerDataAttachmentImpl.setData(player, (Data)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sync(Player player, Data data) {
        void var1_1;
        CatamountPlayerDataAttachmentImpl.sync(player, (Data)var1_1);
    }

    public static void tellDeath(ServerPlayer player, CatamountEntity catamountEntity) {
        Data data = CatamountPlayerDataAttachment.getData((Player)player);
        Data newData = data.withCatamountUUID(Optional.of(catamountEntity.getUUID())).withDeathCooldownTimer(201600);
        CatamountPlayerDataAttachment.setData((Player)player, newData);
    }

    public static void tick(ServerPlayer player) {
        Data data = CatamountPlayerDataAttachment.getData((Player)player);
        boolean updated = false;
        if (data.deathCooldownTimer() > 0) {
            data = data.withDeathCooldownTimer(data.deathCooldownTimer() - 1);
            updated = true;
        }
        if (data.catamountStage() == 0 || data.catamountStage() == 1) {
            data = data.addStageTimer(1);
            updated = true;
        }
        if (updated) {
            CatamountPlayerDataAttachment.setData((Player)player, data);
        }
    }

    public static boolean tryAdvanceStage(Player player) {
        Data data = CatamountPlayerDataAttachment.getData(player);
        int currentStage = data.catamountStage();
        int points = data.points();
        int stageTimer = data.stageTimer();
        int nextStage = -1;
        switch (currentStage) {
            case 0: {
                if (points < 0 && stageTimer < 201600) break;
                nextStage = 1;
                break;
            }
            case 1: {
                if (points < 20 && stageTimer < 144000) break;
                nextStage = 2;
                break;
            }
            case 2: {
                if (points < 50) break;
                nextStage = 3;
                break;
            }
            case 3: {
                if (points < 100) break;
                nextStage = 4;
                break;
            }
            case 4: {
                if (points < 200) break;
                nextStage = 5;
                break;
            }
        }
        if (nextStage > 0) {
            Data newData = data.withCatamountStage(nextStage).withStageTimer(0);
            CatamountPlayerDataAttachment.setData(player, newData);
            return true;
        }
        return false;
    }

    public record Data(Optional<UUID> catamountUUID, int catamountStage, int points, int deathCooldownTimer, int stageTimer, int eventCooldown, int extraDamageTimer, int soulFireTimer, int feedingFrenzyCooldown) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.optionalFieldOf("catamountUUID").forGetter(c -> c.catamountUUID), (App)Codec.INT.fieldOf("catamountStage").forGetter(d -> d.catamountStage), (App)Codec.INT.fieldOf("duration").forGetter(d -> d.points), (App)Codec.INT.fieldOf("deathCooldownTimer").forGetter(d -> d.deathCooldownTimer), (App)Codec.INT.fieldOf("stageTimer").forGetter(d -> d.stageTimer), (App)Codec.INT.optionalFieldOf("eventCooldown", (Object)0).forGetter(d -> d.eventCooldown), (App)Codec.INT.optionalFieldOf("extraDamageTimer", (Object)0).forGetter(d -> d.extraDamageTimer), (App)Codec.INT.optionalFieldOf("soulFireTimer", (Object)0).forGetter(d -> d.soulFireTimer), (App)Codec.INT.optionalFieldOf("feedingFrenzyCooldown", (Object)0).forGetter(d -> d.feedingFrenzyCooldown)).apply((Applicative)instance, Data::new));
        public static final ResourceLocation ID = TheCatamount.id("catamount_player_data");

        public Data() {
            this(Optional.empty(), -1, 0, 0, 0, 0, 0, 0, 0);
        }

        public Data withStageTimer(int timer) {
            return new Data(this.catamountUUID, this.catamountStage, this.points, this.deathCooldownTimer, timer, this.eventCooldown, this.extraDamageTimer, this.soulFireTimer, this.feedingFrenzyCooldown);
        }

        public Data withCatamountStage(int stage) {
            return new Data(this.catamountUUID, stage, this.points, this.deathCooldownTimer, this.stageTimer, this.eventCooldown, this.extraDamageTimer, this.soulFireTimer, this.feedingFrenzyCooldown);
        }

        public Data addStageTimer(int delta) {
            return new Data(this.catamountUUID, this.catamountStage, this.points, this.deathCooldownTimer, this.stageTimer + delta, this.eventCooldown, this.extraDamageTimer, this.soulFireTimer, this.feedingFrenzyCooldown);
        }

        public Data addPoints(int amount) {
            return new Data(this.catamountUUID, this.catamountStage, this.points + amount, this.deathCooldownTimer, this.stageTimer, this.eventCooldown, this.extraDamageTimer, this.soulFireTimer, this.feedingFrenzyCooldown);
        }

        public Data withCatamountUUID(Optional<UUID> newUUID) {
            return new Data(newUUID, this.catamountStage, this.points, this.deathCooldownTimer, this.stageTimer, this.eventCooldown, this.extraDamageTimer, this.soulFireTimer, this.feedingFrenzyCooldown);
        }

        public Data withPoints(int newPoints) {
            return new Data(this.catamountUUID, this.catamountStage, newPoints, this.deathCooldownTimer, this.stageTimer, this.eventCooldown, this.extraDamageTimer, this.soulFireTimer, this.feedingFrenzyCooldown);
        }

        public Data withDeathCooldownTimer(int newCooldown) {
            return new Data(this.catamountUUID, this.catamountStage, this.points, newCooldown, this.stageTimer, this.eventCooldown, this.extraDamageTimer, this.soulFireTimer, this.feedingFrenzyCooldown);
        }

        public Data withEventCooldown(int cooldown) {
            return new Data(this.catamountUUID, this.catamountStage, this.points, this.deathCooldownTimer, this.stageTimer, cooldown, this.extraDamageTimer, this.soulFireTimer, this.feedingFrenzyCooldown);
        }

        public Data withExtraDamageTimer(int timer) {
            return new Data(this.catamountUUID, this.catamountStage, this.points, this.deathCooldownTimer, this.stageTimer, this.eventCooldown, timer, this.soulFireTimer, this.feedingFrenzyCooldown);
        }

        public Data withSoulFireTimer(int timer) {
            return new Data(this.catamountUUID, this.catamountStage, this.points, this.deathCooldownTimer, this.stageTimer, this.eventCooldown, this.extraDamageTimer, timer, this.feedingFrenzyCooldown);
        }

        public Data withFeedingFrenzyCooldown(int cooldown) {
            return new Data(this.catamountUUID, this.catamountStage, this.points, this.deathCooldownTimer, this.stageTimer, this.eventCooldown, this.extraDamageTimer, this.soulFireTimer, cooldown);
        }

        public int getFeedingFrenzyCooldown() {
            return this.feedingFrenzyCooldown;
        }

        public int getEventCooldown() {
            return this.eventCooldown;
        }

        public int getExtraDamageTimer() {
            return this.extraDamageTimer;
        }

        public int getSoulFireTimer() {
            return this.soulFireTimer;
        }
    }
}

