/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.data_attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.sterner.the_catamount.TheCatamount;
import dev.sterner.the_catamount.data_attachment.neoforge.FrozenAnimalDataAttachmentImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class FrozenAnimalDataAttachment {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Data getData(ServerLevel level) {
        return FrozenAnimalDataAttachmentImpl.getData(level);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setData(ServerLevel level, Data data) {
        void var1_1;
        FrozenAnimalDataAttachmentImpl.setData(level, (Data)var1_1);
    }

    public record FrozenRecord(long endTime, float yaw, float pitch) {
        public static final Codec<FrozenRecord> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("endTime").forGetter(FrozenRecord::endTime), (App)Codec.FLOAT.fieldOf("yaw").forGetter(FrozenRecord::yaw), (App)Codec.FLOAT.fieldOf("pitch").forGetter(FrozenRecord::pitch)).apply((Applicative)instance, FrozenRecord::new));
    }

    public record Data(Map<UUID, FrozenRecord> frozenAnimals) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializedEntry.CODEC.listOf().xmap(list -> {
            HashMap map = new HashMap();
            list.forEach(entry -> map.put(entry.uuid(), entry.record()));
            return map;
        }, map -> map.entrySet().stream().map(entry -> new SerializedEntry((UUID)entry.getKey(), (FrozenRecord)entry.getValue())).toList()).fieldOf("frozenAnimals").forGetter(Data::frozenAnimals)).apply((Applicative)instance, Data::new));
        public static final ResourceLocation ID = TheCatamount.id("frozen_animal_data");

        public Data() {
            this(new HashMap<UUID, FrozenRecord>());
        }

        public Data withFrozenAnimal(UUID uuid, long endTime, float yaw, float pitch) {
            HashMap<UUID, FrozenRecord> newMap = new HashMap<UUID, FrozenRecord>(this.frozenAnimals);
            newMap.put(uuid, new FrozenRecord(endTime, yaw, pitch));
            return new Data(newMap);
        }

        public Data withoutFrozenAnimal(UUID uuid) {
            HashMap<UUID, FrozenRecord> newMap = new HashMap<UUID, FrozenRecord>(this.frozenAnimals);
            newMap.remove(uuid);
            return new Data(newMap);
        }

        private record SerializedEntry(UUID uuid, FrozenRecord record) {
            public static final Codec<SerializedEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(SerializedEntry::uuid), (App)FrozenRecord.CODEC.fieldOf("record").forGetter(SerializedEntry::record)).apply((Applicative)instance, SerializedEntry::new));
        }
    }
}

