/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.data_attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.sterner.the_catamount.TheCatamount;
import dev.sterner.the_catamount.data_attachment.neoforge.SoulConversionDataAttachmentImpl;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SoulConversionDataAttachment {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Data getData(ServerLevel level) {
        return SoulConversionDataAttachmentImpl.getData(level);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setData(ServerLevel level, Data data) {
        void var1_1;
        SoulConversionDataAttachmentImpl.setData(level, (Data)var1_1);
    }

    public record ConversionRecord(BlockState originalState, long endTime, @Nullable CompoundTag extraData) {
        public static final Codec<ConversionRecord> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("originalState").forGetter(c -> c.originalState), (App)Codec.LONG.fieldOf("endTime").forGetter(c -> c.endTime), (App)CompoundTag.CODEC.optionalFieldOf("extraData", null).forGetter(c -> c.extraData)).apply((Applicative)instance, ConversionRecord::new));

        public ConversionRecord(BlockState originalState, long endTime) {
            this(originalState, endTime, null);
        }
    }

    public record Data(Map<BlockPos, ConversionRecord> activeConversions) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializedEntry.CODEC.listOf().xmap(list -> {
            HashMap map = new HashMap();
            list.forEach(entry -> {
                BlockPos immutablePos = entry.pos().immutable();
                map.put(immutablePos, entry.record());
            });
            return map;
        }, map -> map.entrySet().stream().map(entry -> new SerializedEntry(((BlockPos)entry.getKey()).immutable(), (ConversionRecord)entry.getValue())).toList()).fieldOf("activeConversions").forGetter(Data::activeConversions)).apply((Applicative)instance, Data::new));
        public static final ResourceLocation ID = TheCatamount.id("soul_conversion_data");

        public Data() {
            this(new HashMap<BlockPos, ConversionRecord>());
        }

        public Data withConversion(BlockPos pos, ConversionRecord record) {
            HashMap<BlockPos, ConversionRecord> newMap = new HashMap<BlockPos, ConversionRecord>(this.activeConversions);
            newMap.put(pos.immutable(), record);
            return new Data(newMap);
        }

        public Data withoutConversion(BlockPos pos) {
            HashMap<BlockPos, ConversionRecord> newMap = new HashMap<BlockPos, ConversionRecord>(this.activeConversions);
            newMap.remove(pos);
            return new Data(newMap);
        }

        private record SerializedEntry(BlockPos pos, ConversionRecord record) {
            public static final Codec<SerializedEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(SerializedEntry::pos), (App)ConversionRecord.CODEC.fieldOf("record").forGetter(SerializedEntry::record)).apply((Applicative)instance, SerializedEntry::new));
        }
    }
}

