/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import dev.sterner.the_catamount.TheCatamount;
import dev.sterner.the_catamount.data_attachment.CatamountPlayerDataAttachment;
import dev.sterner.the_catamount.entity.SmoothCatamountMoveControl;
import dev.sterner.the_catamount.entity.brain.CatamountBrain;
import dev.sterner.the_catamount.registry.TCDataComponents;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CatamountEntity
extends PathfinderMob
implements GeoEntity {
    private static final EntityDataAccessor<Integer> STAGE = SynchedEntityData.defineId(CatamountEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(CatamountEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> ANIMALS_CONSUMED = SynchedEntityData.defineId(CatamountEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> HUMANOIDS_CONSUMED = SynchedEntityData.defineId(CatamountEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FEEDING_FRENZY = SynchedEntityData.defineId(CatamountEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> FRENZY_KILLS_REMAINING = SynchedEntityData.defineId(CatamountEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FULLY_MANIFESTED = SynchedEntityData.defineId(CatamountEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_CROUCHED = SynchedEntityData.defineId(CatamountEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.defineId(CatamountEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<AttackType> ATTACK_TYPE = SynchedEntityData.defineId(CatamountEntity.class, TheCatamount.ATTACK_TYPE);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    protected static final RawAnimation IDLE_CROUCHED = RawAnimation.begin().thenLoop("idle_crouched");
    protected static final RawAnimation MOVEMENT = RawAnimation.begin().thenLoop("movement");
    protected static final RawAnimation MOVEMENT_QUAD = RawAnimation.begin().thenLoop("movement_quad");
    protected static final RawAnimation RUNNING = RawAnimation.begin().thenLoop("running");
    protected static final RawAnimation POUNCE = RawAnimation.begin().thenPlay("pounce");
    protected static final RawAnimation ATTACK_CLAW_LEFT = RawAnimation.begin().thenPlay("attack_claw_left");
    protected static final RawAnimation ATTACK_CLAW_LEFT_CROUCHED = RawAnimation.begin().thenPlay("attack_claw_left_crouched");
    protected static final RawAnimation ATTACK_CLAW_RIGHT_CROUCHED = RawAnimation.begin().thenPlay("attack_claw_right_crouched");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CatamountEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new SmoothCatamountMoveControl((Mob)this, 10, 1.0f);
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STAGE, (Object)3);
        builder.define(OWNER_UUID, Optional.empty());
        builder.define(ANIMALS_CONSUMED, (Object)0);
        builder.define(HUMANOIDS_CONSUMED, (Object)0);
        builder.define(FEEDING_FRENZY, (Object)false);
        builder.define(FRENZY_KILLS_REMAINING, (Object)0);
        builder.define(FULLY_MANIFESTED, (Object)false);
        builder.define(IS_CROUCHED, (Object)false);
        builder.define(IS_ATTACKING, (Object)false);
        builder.define(ATTACK_TYPE, (Object)AttackType.NONE);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(IS_ATTACKING, (Object)attacking);
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("catamountBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().popPush("catamountActivityUpdate");
        CatamountBrain.updateActivity(this);
        this.level().getProfiler().pop();
    }

    @NotNull
    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return CatamountBrain.makeBrain(this, dynamic);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Brain.Provider<CatamountEntity> brainProvider() {
        return Brain.provider(CatamountBrain.MEMORIES, CatamountBrain.SENSORS);
    }

    @NotNull
    public Brain<CatamountEntity> getBrain() {
        return super.getBrain();
    }

    public void tick() {
        long dayTime;
        super.tick();
        if (!this.level().isClientSide && this.isFullyManifested() && ((dayTime = this.level().getDayTime() % 24000L) >= 23000L || dayTime < 1000L)) {
            this.despawnIntoWind();
        }
    }

    public boolean isActuallyMoving(CatamountEntity entity) {
        Vec3 m = entity.getDeltaMovement();
        return m.horizontalDistanceSqr() > 1.0E-4;
    }

    private void despawnIntoWind() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            CatamountPlayerDataAttachment.Data data;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + 1.0, this.getZ(), 30, 0.5, 0.5, 0.5, 0.1);
            serverLevel.playSound(null, this.blockPosition(), SoundEvents.BREEZE_DEATH, SoundSource.HOSTILE, 1.0f, 1.0f);
            ServerPlayer owner = this.getOwnerPlayer();
            if (owner != null && (data = CatamountPlayerDataAttachment.getData((Player)owner)).catamountUUID().isPresent() && data.catamountUUID().get().equals(this.getUUID())) {
                CatamountPlayerDataAttachment.setData((Player)owner, data.withCatamountUUID(Optional.empty()));
            }
        }
        this.discard();
    }

    public void updateDynamicAttributes() {
        double baseHP = switch (this.getStage()) {
            case 3 -> 50.0;
            case 4 -> 150.0;
            case 5 -> 300.0;
            default -> 50.0;
        };
        double hp = baseHP + (double)(this.getAnimalsConsumed() * (this.getStage() >= 4 ? 5 : 3)) + (double)(this.getHumanoidsConsumed() * (this.getStage() >= 4 ? 10 : 5));
        if (this.getStage() == 5) {
            hp = Math.min(hp, 500.0);
        }
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(hp);
        if ((double)this.getHealth() > hp) {
            this.setHealth((float)hp);
        }
        int prevStage = this.getStage();
    }

    private void updateAttributesForStage(int stage) {
        switch (stage) {
            case 3: {
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(5.0);
                this.getAttribute(Attributes.ARMOR).setBaseValue(0.0);
                this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(0.0);
                this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.5);
                break;
            }
            case 4: {
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(8.0);
                this.getAttribute(Attributes.ARMOR).setBaseValue(5.0);
                this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(5.0);
                this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.75);
                break;
            }
            case 5: {
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(10.0);
                this.getAttribute(Attributes.ARMOR).setBaseValue(10.0);
                this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(10.0);
                this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
            }
        }
        this.updateDynamicAttributes();
    }

    public boolean hurt(DamageSource source, float amount) {
        float resistance;
        if (this.isWhiteAshWeapon(source)) {
            return super.hurt(source, amount *= 1.5f);
        }
        if (source.is(DamageTypes.FALL) || source.is(DamageTypes.CACTUS) || source.is(DamageTypes.SWEET_BERRY_BUSH) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.DROWN) || this.getStage() == 5 && (source.is(DamageTypes.LAVA) || source.is(DamageTypes.ON_FIRE))) {
            if (source.is(DamageTypes.DROWN) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.LAVA)) {
                this.teleportOut();
            }
            return false;
        }
        switch (this.getStage()) {
            case 3: {
                float f = 0.8f;
                break;
            }
            case 4: {
                float f = 0.6f;
                break;
            }
            case 5: {
                float f = 0.4f;
                break;
            }
            default: {
                float f = resistance = 1.0f;
            }
        }
        if (!this.isWhiteAshWeapon(source)) {
            amount *= resistance;
        }
        return super.hurt(source, amount);
    }

    private void teleportOut() {
        if (this.level().isClientSide) {
            return;
        }
        RandomSource random = this.getRandom();
        BlockPos currentPos = this.blockPosition();
        Level level = this.level();
        int MAX_ATTEMPTS = 16;
        int MAX_HORIZONTAL_DISTANCE = 12;
        int MAX_VERTICAL_DISTANCE = 8;
        for (int attempt = 0; attempt < 16; ++attempt) {
            int dx = random.nextIntBetweenInclusive(-12, 12);
            int dy = random.nextIntBetweenInclusive(-8, 8);
            int dz = random.nextIntBetweenInclusive(-12, 12);
            BlockPos targetPos = currentPos.offset(dx, dy, dz);
            while (targetPos.getY() > level.getMinBuildHeight() && !level.getBlockState(targetPos.below()).isSolid()) {
                targetPos = targetPos.below();
            }
            AABB checkBox = this.getBoundingBox().move((double)targetPos.getX() + 0.5 - this.getX(), (double)targetPos.getY() - this.getY(), (double)targetPos.getZ() + 0.5 - this.getZ());
            if (!level.noCollision((Entity)this, checkBox) || !level.getBlockState(targetPos.below()).isSolid()) continue;
            this.teleportTo((double)targetPos.getX() + 0.5, targetPos.getY() + 1, (double)targetPos.getZ() + 0.5);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.3, 0.5, 0.3, 0.02);
                serverLevel.playSound(null, this.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.HOSTILE, 1.0f, 0.8f + random.nextFloat() * 0.4f);
            }
            return;
        }
        Vec3 fallback = this.position().add((random.nextDouble() - 0.5) * 4.0, 0.0, (random.nextDouble() - 0.5) * 4.0);
        this.teleportTo(fallback.x, fallback.y, fallback.z);
    }

    private boolean isWhiteAshWeapon(DamageSource source) {
        LivingEntity living;
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getMainHandItem().has(TCDataComponents.WHITE_ASH_COATED)) {
            return Boolean.TRUE.equals(living.getMainHandItem().get(TCDataComponents.WHITE_ASH_COATED));
        }
        return false;
    }

    public int getAnimalsConsumed() {
        return (Integer)this.entityData.get(ANIMALS_CONSUMED);
    }

    public int getHumanoidsConsumed() {
        return (Integer)this.entityData.get(HUMANOIDS_CONSUMED);
    }

    public void setAnimalsConsumed(int consumed) {
        this.entityData.set(ANIMALS_CONSUMED, (Object)consumed);
    }

    public void increaseAnimalsConsumed() {
        this.setAnimalsConsumed(this.getAnimalsConsumed() + 1);
    }

    public void setHumanoidsConsumed(int consumed) {
        this.entityData.set(HUMANOIDS_CONSUMED, (Object)consumed);
    }

    public void increaseHumanoidsConsumed() {
        this.setHumanoidsConsumed(this.getHumanoidsConsumed() + 1);
    }

    public int getStage() {
        return (Integer)this.entityData.get(STAGE);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.entityData.get(OWNER_UUID);
    }

    public void setStage(int stage) {
        this.entityData.set(STAGE, (Object)stage);
    }

    public void setOwnerUUID(Optional<UUID> ownerUUID) {
        this.entityData.set(OWNER_UUID, ownerUUID);
    }

    public boolean isFeedingFrenzy() {
        return (Boolean)this.entityData.get(FEEDING_FRENZY);
    }

    public void setFeedingFrenzy(boolean frenzy) {
        this.entityData.set(FEEDING_FRENZY, (Object)frenzy);
    }

    public int getFrenzyKillsRemaining() {
        return (Integer)this.entityData.get(FRENZY_KILLS_REMAINING);
    }

    public void setFrenzyKillsRemaining(int remaining) {
        this.entityData.set(FRENZY_KILLS_REMAINING, (Object)remaining);
    }

    public boolean isFullyManifested() {
        return (Boolean)this.entityData.get(FULLY_MANIFESTED);
    }

    public void setFullyManifested(boolean manifested) {
        this.entityData.set(FULLY_MANIFESTED, (Object)manifested);
    }

    public boolean isCrouched() {
        return (Boolean)this.entityData.get(IS_CROUCHED);
    }

    public void setCrouched(boolean crouched) {
        this.entityData.set(IS_CROUCHED, (Object)crouched);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Stage", this.getStage());
        compound.putInt("AnimalsConsumed", this.getAnimalsConsumed());
        compound.putInt("HumanoidsConsumed", this.getHumanoidsConsumed());
        compound.putBoolean("FeedingFrenzy", this.isFeedingFrenzy());
        compound.putInt("FrenzyKillsRemaining", this.getFrenzyKillsRemaining());
        compound.putBoolean("FullyManifested", this.isFullyManifested());
        compound.putBoolean("IsCrouched", this.isCrouched());
        if (this.getOwnerUUID().isPresent()) {
            compound.putUUID("OwnerUUID", this.getOwnerUUID().get());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setStage(compound.getInt("Stage"));
        if (compound.hasUUID("OwnerUUID")) {
            this.setOwnerUUID(Optional.of(compound.getUUID("OwnerUUID")));
        } else {
            this.setOwnerUUID(Optional.empty());
        }
        this.setAnimalsConsumed(compound.getInt("AnimalsConsumed"));
        this.setHumanoidsConsumed(compound.getInt("HumanoidsConsumed"));
        this.setFeedingFrenzy(compound.getBoolean("FeedingFrenzy"));
        this.setFrenzyKillsRemaining(compound.getInt("FrenzyKillsRemaining"));
        this.setFullyManifested(compound.getBoolean("FullyManifested"));
        this.setCrouched(compound.getBoolean("IsCrouched"));
        this.updateAttributesForStage(this.getStage());
    }

    public void die(DamageSource source) {
        CatamountPlayerDataAttachment.Data data;
        ServerPlayer owner;
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CatamountPlayerDataAttachment.tellDeath(player, this);
        }
        if ((owner = this.getOwnerPlayer()) != null && (data = CatamountPlayerDataAttachment.getData((Player)owner)).catamountUUID().isPresent() && data.catamountUUID().get().equals(this.getUUID())) {
            CatamountPlayerDataAttachment.setData((Player)owner, data.withCatamountUUID(Optional.empty()));
        }
        super.die(source);
    }

    public boolean doHurtTarget(Entity target) {
        boolean hurt = super.doHurtTarget(target);
        if (hurt && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            boolean isPounce = this.entityData.get(ATTACK_TYPE) == AttackType.POUNCE;
            this.triggerAttackAnimation(living, isPounce);
            if (this.isFeedingFrenzy() && living.getHealth() <= 0.0f) {
                this.onFrenzyKill(living);
            }
        }
        return hurt;
    }

    private void onFrenzyKill(LivingEntity victim) {
        Level level;
        if (this.level().isClientSide) {
            return;
        }
        int killsLeft = this.getFrenzyKillsRemaining();
        if (killsLeft <= 0) {
            return;
        }
        ServerPlayer owner = this.getOwnerPlayer();
        if (owner == null) {
            return;
        }
        int points = (int)victim.getMaxHealth();
        if (victim instanceof Animal) {
            this.increaseAnimalsConsumed();
        } else if (victim instanceof Villager || victim instanceof AbstractVillager) {
            this.increaseHumanoidsConsumed();
        }
        CatamountPlayerDataAttachment.Data data = CatamountPlayerDataAttachment.getData((Player)owner);
        CatamountPlayerDataAttachment.setData((Player)owner, data.addPoints(points));
        this.setFrenzyKillsRemaining(killsLeft - 1);
        if (this.getFrenzyKillsRemaining() <= 0) {
            this.exitFrenzyMode();
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, victim.getX(), victim.getY() + (double)(victim.getBbHeight() / 2.0f), victim.getZ(), 20, 0.5, 0.5, 0.5, 0.1);
        }
    }

    @Nullable
    private ServerPlayer getOwnerPlayer() {
        ServerLevel serverLevel;
        Entity entity;
        if (this.getOwnerUUID().isEmpty()) {
            return null;
        }
        Level level = this.level();
        if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(this.getOwnerUUID().get())) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return player;
        }
        return null;
    }

    private void exitFrenzyMode() {
        this.setFeedingFrenzy(false);
        this.setFrenzyKillsRemaining(0);
        this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.HOSTILE, 1.0f, 0.8f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movement", 5, this::movementController));
        controllers.add(new AnimationController((GeoAnimatable)this, "attack", 0, this::attackController));
    }

    protected <E extends CatamountEntity> PlayState movementController(AnimationState<E> event) {
        if (((Boolean)this.entityData.get(IS_ATTACKING)).booleanValue()) {
            return PlayState.CONTINUE;
        }
        if (this.isActuallyMoving((CatamountEntity)event.getAnimatable())) {
            double speed = this.getDeltaMovement().horizontalDistance();
            if (this.isCrouched()) {
                if (speed > 0.12) {
                    return event.setAndContinue(RUNNING);
                }
                return event.setAndContinue(MOVEMENT_QUAD);
            }
            return event.setAndContinue(MOVEMENT);
        }
        if (this.isCrouched()) {
            return event.setAndContinue(IDLE_CROUCHED);
        }
        return event.setAndContinue(IDLE);
    }

    protected <E extends CatamountEntity> PlayState attackController(AnimationState<E> event) {
        if (!this.isAttacking()) {
            this.entityData.set(ATTACK_TYPE, (Object)AttackType.NONE);
            return PlayState.STOP;
        }
        if (this.entityData.get(ATTACK_TYPE) == AttackType.NONE) {
            return PlayState.STOP;
        }
        return switch (((AttackType)((Object)this.entityData.get(ATTACK_TYPE))).ordinal()) {
            case 1 -> event.setAndContinue(POUNCE);
            case 2 -> {
                if (this.isCrouched()) {
                    yield event.setAndContinue(ATTACK_CLAW_LEFT_CROUCHED);
                }
                yield event.setAndContinue(ATTACK_CLAW_LEFT);
            }
            case 3 -> event.setAndContinue(ATTACK_CLAW_RIGHT_CROUCHED);
            default -> PlayState.STOP;
        };
    }

    public void triggerAttackAnimation(LivingEntity target, boolean isPounce) {
        this.setAttacking(true);
        if (isPounce) {
            this.entityData.set(ATTACK_TYPE, (Object)AttackType.POUNCE);
        } else if (this.isCrouched()) {
            this.entityData.set(ATTACK_TYPE, (Object)(this.entityData.get(ATTACK_TYPE) == AttackType.CLAW_LEFT ? AttackType.CLAW_RIGHT : AttackType.CLAW_LEFT));
        } else {
            this.entityData.set(ATTACK_TYPE, (Object)AttackType.CLAW_LEFT);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum AttackType implements StringRepresentable
    {
        NONE,
        POUNCE,
        CLAW_LEFT,
        CLAW_RIGHT;

        public static Codec<AttackType> CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, AttackType> STREAM_CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(AttackType::values);
            STREAM_CODEC = StreamCodec.of((buf, value) -> buf.writeUtf(value.getSerializedName()), buf -> AttackType.valueOf(buf.readUtf().toUpperCase(Locale.ROOT)));
        }
    }
}

