/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.level.Level;

public class DevouredEntity
extends Vex {
    private static final int MAX_LIFETIME = 6000;
    private int lifetimeTicks = 0;

    public DevouredEntity(EntityType<? extends Vex> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Vex.createAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            ++this.lifetimeTicks;
            if (this.level().isDay() && this.level().canSeeSky(this.blockPosition())) {
                this.despawnIntoSmoke();
                return;
            }
            if (this.lifetimeTicks >= 6000) {
                this.despawnIntoSmoke();
            }
        }
    }

    private void despawnIntoSmoke() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + 0.5, this.getZ(), 10, 0.3, 0.3, 0.3, 0.02);
        }
        this.discard();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.FALL) || source.is(DamageTypes.DROWN) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.CACTUS)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    protected void registerGoals() {
        super.registerGoals();
    }
}

