/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LightOrbEntity
extends Entity {
    private static final int MAX_LIFETIME = 1200;
    private int lifetimeTicks = 0;
    private Vec3 glideDirection;
    private float height;

    public LightOrbEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        double angle = level.random.nextDouble() * Math.PI * 2.0;
        this.glideDirection = new Vec3(Math.cos(angle), 0.0, Math.sin(angle)).normalize();
        this.height = (float)this.getY();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            Level level;
            ++this.lifetimeTicks;
            float bobbing = (float)Math.sin((double)this.lifetimeTicks * 0.05) * 0.05f;
            Vec3 movement = this.glideDirection.scale(0.05);
            movement = movement.add(0.0, (double)bobbing, 0.0);
            this.setDeltaMovement(movement);
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (this.lifetimeTicks % 100 == 0) {
                this.height -= 0.5f;
                this.setPos(this.getX(), this.height, this.getZ());
            }
            if ((level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY(), this.getZ(), 2, 0.1, 0.1, 0.1, 0.01);
            }
            if (this.lifetimeTicks >= 1200 || this.getY() < (double)(this.level().getMinBuildHeight() + 10)) {
                this.discard();
            }
        } else {
            this.level().addParticle((ParticleOptions)ParticleTypes.GLOW, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.lifetimeTicks = tag.getInt("LifetimeTicks");
        this.height = tag.getFloat("Height");
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("LifetimeTicks", this.lifetimeTicks);
        tag.putFloat("Height", this.height);
    }
}

