/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.the_catamount.entity;

import dev.sterner.the_catamount.entity.CatamountEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class SmoothCatamountMoveControl
extends MoveControl {
    private final int maxTurnY;
    private final float outsideWaterSpeedModifier;

    public SmoothCatamountMoveControl(Mob mob, int maxTurnY, float outsideWaterSpeedModifier) {
        super(mob);
        this.maxTurnY = maxTurnY;
        this.outsideWaterSpeedModifier = outsideWaterSpeedModifier;
    }

    public void tick() {
        LivingEntity target;
        CatamountEntity cat;
        double dz;
        double dy;
        if (this.operation != MoveControl.Operation.MOVE_TO || this.mob.getNavigation().isDone()) {
            this.mob.setSpeed(0.0f);
            this.mob.setXxa(0.0f);
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
            return;
        }
        double dx = this.wantedX - this.mob.getX();
        double distanceSq = dx * dx + (dy = this.wantedY - this.mob.getY()) * dy + (dz = this.wantedZ - this.mob.getZ()) * dz;
        if (distanceSq < 1.0E-7) {
            this.mob.setZza(0.0f);
            return;
        }
        float pathYaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
        Mob mob = this.mob;
        if (mob instanceof CatamountEntity && (cat = (CatamountEntity)mob).getTarget() != null && (target = cat.getTarget()).isAlive()) {
            double tx = target.getX() - this.mob.getX();
            double tz = target.getZ() - this.mob.getZ();
            pathYaw = (float)(Math.toDegrees(Math.atan2(tz, tx)) - 90.0);
        }
        this.mob.setYRot(SmoothCatamountMoveControl.approachDegrees(this.mob.getYRot(), pathYaw, this.maxTurnY));
        this.mob.yBodyRot = this.mob.getYRot();
        this.mob.yHeadRot = this.mob.getYRot();
        float speed = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
        float yawDiff = Math.abs(Mth.wrapDegrees((float)(this.mob.getYRot() - pathYaw)));
        float turnFactor = SmoothCatamountMoveControl.getTurningSpeedFactor(yawDiff);
        this.mob.setSpeed(speed * this.outsideWaterSpeedModifier * turnFactor);
    }

    private static float getTurningSpeedFactor(float degreesToTurn) {
        return 1.0f - Mth.clamp((float)((degreesToTurn - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
    }

    private static float approachDegrees(float current, float target, float maxDelta) {
        float delta = Mth.wrapDegrees((float)(target - current));
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (delta < -maxDelta) {
            delta = -maxDelta;
        }
        return current + delta;
    }
}

